<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --caramel: #b87333;
            /* primary accent */
            --latte: #d6a25e;
            /* secondary accent */
            --ink: #3b2613;
            /* main text */
            --muted: #7a6a58;
            /* secondary text */
            --page: #f7f2e9;
            /* paper base */
            --page2: #efe4d6;
            /* warm blend */
            --card: #fffaf2;
            /* card paper */
            --chip: #f8f1e6;
            /* soft chip */
            --line: rgba(0, 0, 0, .08);
            --shadow: 0 12px 28px rgba(184, 115, 51, .18);
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(900px 600px at 55% 8%, rgba(255, 255, 255, .7), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat fixed,
                linear-gradient(var(--page), var(--page2) 60%, var(--page));
            padding-bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .container {
            max-width: 540px;
            margin: 16px auto;
            padding: 0 14px
        }

        /* Header */
        .header {
            position: sticky;
            top: 0;
            z-index: 5;
            margin: 0 -14px 12px;
            padding: 14px;
            text-align: center;
            font-size: 18px;
            font-weight: 900;
            letter-spacing: .3px;
            color: var(--caramel);
            background: linear-gradient(180deg, #ffffff, var(--card));
            border-bottom: 1px solid var(--line);
            box-shadow: var(--shadow);
            text-shadow: 0 0 10px rgba(184, 115, 51, .18);
        }

        .header a {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            text-decoration: none;
            color: var(--caramel);
            font-weight: 900;
            font-size: 18px;
            padding: 6px 10px;
            border: 1px solid var(--line);
            border-radius: 10px;
            background: linear-gradient(180deg, #fff7ec, var(--chip));
            transition: .2s;
            box-shadow: 0 6px 18px rgba(184, 115, 51, .15);
        }

        .header a:hover {
            color: var(--latte);
            filter: brightness(1.05)
        }

        /* User Record Card */
        .user-record {
            background: linear-gradient(180deg, #ffffff, var(--card));
            border: 1px solid var(--line);
            border-radius: 16px;
            padding: 14px 16px;
            margin-bottom: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: var(--shadow);
            transition: transform .2s ease, box-shadow .2s ease;
        }

        .user-record:hover {
            transform: translateY(-2px);
            box-shadow: 0 16px 36px rgba(184, 115, 51, .22);
        }

        .user-info {
            display: flex;
            flex-direction: column
        }

        .user-phone {
            font-weight: 900;
            font-size: 16px;
            color: var(--ink);
        }

        .user-date {
            font-size: 12px;
            color: var(--muted);
            margin-top: 4px
        }

        .user-right {
            text-align: right
        }

        .user-amount {
            color: var(--caramel);
            font-size: 16px;
            font-weight: 900
        }

        .user-label {
            font-size: 12px;
            color: var(--muted)
        }

        /* Bottom Tab Bar (Coffeehouse) */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(8px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
            box-shadow: 0 -4px 16px rgba(184, 115, 51, .20);
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            padding: 10px 0;
            transition: color .2s;
        }

        .tab .ico {
            width: 20px;
            height: 20px;
            color: var(--muted);
            transition: color .2s
        }

        .tab.active {
            color: var(--caramel)
        }

        .tab.active .ico {
            color: var(--caramel)
        }

        .tab:hover {
            color: var(--latte)
        }

        .tab:hover .ico {
            color: var(--latte)
        }
    </style>

    <body>
        <div class="container">
            <div class="header">
                <a href="#" onclick="window.location.href='<?php echo e(route('user.referrals')); ?>'" aria-label="Back">‹</a>
                Level <?php echo e($level); ?> Active
            </div>

            <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="user-record">
                <div class="user-info">
                    <div class="user-phone"><?php echo e($user->mobile); ?></div>
                    <div class="user-date">Joined: <?php echo e($user->created_at->format('M d, Y . h:i a')); ?></div>
                </div>
                <div class="user-right">
                    <div class="user-amount"><?php echo e($general->cur_sym); ?><?php echo e(number_format($user->total_investment)); ?></div>
                    <div class="user-label">Total Invest</div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

        <!-- Bottom Tab Bar -->
        <?php echo $__env->make('templates.basic.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4d8c87fd4f7068&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/referral_list.blade.php ENDPATH**/ ?>