<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --ink: #3b2613;
            /* text */
            --muted: #7a6a58;
            /* secondary */
            --page1: #f7f2e9;
            /* paper */
            --page2: #efe4d6;
            /* warm blend */
            --card: #fffaf2;
            /* card */
            --line: rgba(0, 0, 0, .08);
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --success: #1a9a73;
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
            --shadow-soft: 0 6px 20px rgba(184, 115, 51, .18);
            --shadow-hover: 0 10px 28px rgba(184, 115, 51, .28);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(900px 600px at 50% 8%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                linear-gradient(180deg, var(--page1), var(--page2) 80%, var(--page1));
        }

        /* Wrapper */
        .app {
            max-width: 540px;
            margin: 0 auto;
            padding: 16px;
            padding-bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .title {
            font-size: 22px;
            font-weight: 900;
            text-align: center;
            color: var(--accent);
            letter-spacing: .3px;
            margin: 12px 0 6px;
            text-shadow: 0 0 10px rgba(184, 115, 51, .22);
        }

        .subtitle {
            text-align: center;
            font-size: 13px;
            color: var(--muted);
            font-weight: 700;
            letter-spacing: .2px;
            margin-bottom: 16px;
        }

        /* Card list */
        .list {
            display: flex;
            flex-direction: column;
            gap: 16px
        }

        .card {
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1px solid var(--line);
            border-radius: 18px;
            box-shadow: var(--shadow-soft);
            padding: 8px 14px;
            transition: transform .2s ease, box-shadow .2s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-hover);
        }

        .row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px 2px;
            font-size: 14px;
        }

        .row+.row {
            border-top: 1px solid var(--line);
        }

        .k {
            color: var(--muted);
            font-weight: 700;
        }

        .v {
            font-weight: 900;
        }

        .v.date {
            color: var(--accent);
        }

        .v.amount {
            color: var(--accent);
            display: flex;
            gap: 6px;
            align-items: baseline;
            font-size: 16px;
        }

        .peso {
            opacity: .9;
            font-weight: 800;
        }

        .status {
            font-weight: 900;
            color: var(--success);
        }

        /* Empty state */
        .empty {
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1px dashed var(--line);
            color: var(--muted);
            padding: 28px 14px;
            border-radius: 16px;
            text-align: center;
            font-weight: 700;
            box-shadow: 0 6px 20px rgba(184, 115, 51, .14);
        }

        /* Tab Bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
            box-shadow: 0 -4px 16px rgba(184, 115, 51, .20);
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            transition: color .2s ease;
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent)
        }

        .tab.active .ico {
            color: var(--accent)
        }

        .tab:hover {
            color: var(--accent2)
        }
    </style>

    <body>

        <div class="app">
            <div class="title">Income Record</div>
            <div class="subtitle">Daily income history</div>

            <div class="list">
                <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <article class="card">
                        <div class="row">
                            <div class="k">Income Date</div>
                            <div class="v date"><?php echo e($data->created_at); ?></div>
                        </div>

                        <!-- Order ID Row -->
                        <div class="row">
                            <div class="k">Details</div>
                            <div class="v"><?php echo e($data->details); ?></div>
                        </div>

                        <div class="row">
                            <div class="k">Money</div>
                            <div class="v amount"><span class="peso"><?php echo e($data->trx_type); ?>

                                    (<?php echo e($general->cur_sym); ?>)</span><?php echo e(number_format($data->amount)); ?></div>
                        </div>

                    </article>


                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="empty">No income records found.</div>
                <?php endif; ?>

            </div>
        </div>

        <!-- Bottom Tab Bar -->
        <?php echo $__env->make('templates.basic.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4d04787fec7dcd&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/trx_log.blade.php ENDPATH**/ ?>