<?php $__env->startSection('content'); ?>

<section class="opay_wrap">
    <header class="header_top main_Wrap">
        <div class="inner">
            <h1>Welcome, <?php echo e($user->phone); ?></h1>
            <ul>
                <li><a href="javascript:void(0)"><i class="fa fa-qrcode"></i></a></li>
                <li><a href="javascript:void(0)"><i class="fa fa-user-circle-o"></i></a></li>
                <li><a href="javascript:void(0)"><i class="fa fa-bell-o"></i></a></li>
            </ul>
        </div>
    </header>
    <div class="opay_body product_page">
        <div class="row">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



           <div class="col-12">
            <div class="card product_card">
            <div class="card_inner">
                <div class="card_img">
                    <img src="<?php echo e(asset('user/assets/images/logo.jpeg')); ?>" alt="lake">
                    <div class="award_icon"></div>
                </div>
                <div class="card_body">
                    <h1><?php echo e($plan->name); ?></h1>
                    <p class="f-14">Finance price: <span>₦<?php echo e(number_format($plan->min_amount, 2)); ?></span></p>
                    <p class="f-14">Revenue cycle: <span>₦<?php echo e(number_format($plan->total_return * $plan->interest_amount, 2)); ?></span></p>
                    <p class="f-14">Daily revenue: <span>₦<?php echo e(number_format($plan->interest_amount, 2)); ?></span></p>
                    <p class="f-14">Duration:  <span><?php echo e($plan->total_return); ?> days</span></p>
                </div>
            </div>
            <form action="<?php echo e(route('user.investment')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input name="id" type="hidden" value="<?php echo e($plan->id); ?>">
                <button type="submit" class="theme_btn mt-3">Buy Now</button>
            </form>
            </div>
           </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php echo $__env->make('partials.user._bottom_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</section>


<?php $__env->stopSection(); ?>



<?php $__env->startPush('style'); ?>
    <style type="text/css">
        #copyBoard {
            cursor: pointer;
            height: 100%;
        }

        .input-group-text {
            background-color: #0a1227;
            border: 1px solid #373768;
            color: #fff;
        }

        #referralURL {
            background: #20204e;
            border-color: #20204e;
            color: #fff;
        }

        #social-links ul li {
            list-style: none !important;
            display: inline-block;
        }

        #social-links ul a {
            display: block;
            padding: 4px 10px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2({
                theme: "classic"
            });
        });
        (function($) {

            "use strict";
            $('.planModal').on('click', function() {
                var modal = $('#planModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find($('#planModalLabel').text($(this).data('name')));
            });
            $('.copyBoard').click(function() {
                "use strict";
                var copyText = document.getElementById("referralURL");
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                iziToast.success({
                    message: "Copied: " + copyText.value,
                    position: "topRight"
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/AMPPS/www/palmpay/core/resources/views/templates/basic/user/plans.blade.php ENDPATH**/ ?>