<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('static/index/v1/css/card.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('static/index/v1/css/withdraw.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('static/index/v1/css/paymentrecord.css')); ?>">

    <body>
        <div class="headerbg flex_be">
            <div class="flex_sta">
                <img class="back" src="<?php echo e(asset('uploads/material/back.png')); ?>" alt="">
                <p class="pagetitle">Withdraw</p>
            </div>
            <div class="flex_sta icons">
                <a href="<?php echo e(route('user.referrals')); ?>"><img src="<?php echo e(asset('uploads/material/toteamicon.png')); ?>"
                        alt=""></a>
                <a class="sharebutton"><img src="<?php echo e(asset('uploads/material/toshareicon.png')); ?>" alt=""></a>
            </div>
        </div>



        <a href="<?php echo e($general->telegram_chat_id); ?>" class="kfimg" style="z-index: 999">
            <img src="<?php echo e(asset('uploads/material/kf.png')); ?>" alt="">
        </a>
        <div class="centeritem outerbox">
            <div class="cardinfo">
                <img class="cardbg" src="<?php echo e(asset('uploads/material/cardbg.png')); ?>" alt="">
                <div class="cardcontent">
                    <div class="flex_sta totaltitle">
                        <img src="<?php echo e(asset('uploads/material/cardcoin.png')); ?>" alt="">
                        <p>Total Balance</p>
                    </div>
                    <h6><?php echo e($general->cur_sym); ?><?php echo e(number_format(auth()->user()->bonus_balance)); ?></h6>
                    <div class="please">
                        <div class="flex_sta">
                            <img src="<?php echo e(asset('uploads/material/cardgreen.png')); ?>" alt="">
                            <div>
                                <?php if(auth()->user()->bankAccount): ?>
                                    <p><?php echo e(substr(auth()->user()->bankAccount->account_number, 0, 3) . str_repeat('*', 4) . substr(auth()->user()->bankAccount->account_number, 7)); ?>

                                        <br>
                                        Bank: <?php echo e(auth()->user()->bankAccount->bank_name); ?>

                                    <?php else: ?>
                                        <a href="<?php echo e(route('user.account-setup')); ?>" class="bindcard">Please bind your bank
                                            card
                                            first</a>
                                    <p>Bank Account</p>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form action="<?php echo e(route('user.withdraw')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="withdrawBalance" name="balance" value="2">
                <input type="hidden" id="withdrawMethodCode" name="method_code" value="1">
                <div class="withdrawbox">
                    <p class="amountitle">Amount</p>
                    <div class="inputbox">
                        <img src="<?php echo e(asset('uploads/material/icon.png')); ?>" alt="">
                        <input type="number" id="withdrawAmount" placeholder="Please enter the withdrawal amount">
                    </div>
                    <p class="rule">Processing Time：7×24h</p>
                    <p class="rule">Min
                        Withdrawal：<?php echo e($general->cur_sym); ?><?php echo e(number_format($withdrawMainMethod->min_limit)); ?></p>
                    <p class="rule">
                        Fees：<?php echo e(round($withdrawMainMethod->percent_charge) == 0 ? 'none' : round($withdrawMainMethod->percent_charge) . '%'); ?>

                    </p>
                    <button style="border:none;" class="withdrawbtn" id="withdrawButton"
                        onclick="submitWithdraw()">Withdraw</button>
                </div>
            </form>
        </div>
        <div class="detailbox withdrawrecord">
            <h3>Withdraw Record</h3>
            <ul class="list data-list" style="display: block;">
                <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="flex_be">
                        <div class="recordleft">
                            <div class="flex_be">
                                <p>Time</p>
                                <span><?php echo e($data->created_at->format('h:i:s d M Y')); ?></span>
                            </div>
                            <div class="flex_be">
                                <p>Amount:</p>
                                <span><?php echo e($general->cur_sym); ?><?php echo e(number_format($data->amount)); ?></span>
                            </div>
                        </div>
                        <?php if($data->status == 2): ?>
                            <div class="recordright flex_cen confirming">Confirming</div>
                        <?php elseif($data->status == 1): ?>
                            <div class="recordright flex_cen ">Success</div>
                        <?php elseif($data->status == 3): ?>
                            <div class="recordright flex_cen Unconfirmed">Unconfirmed</div>
                        <?php endif; ?>

                        <div class="pointposi"></div>
                        <div class="pointposib"></div>
                    </li>



                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <div class="nothing empty" style="">
                        <img src="<?php echo e(asset('uploads/material/nothing.png')); ?>" alt="">
                        <p>No record</p>
                    </div>
                <?php endif; ?>
            </ul>


        </div>
        <div class="footer flex_be">
            <a href="<?php echo e(route('user.home')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\f009397ad7700e00d7a6d8189fefe4d3.png')); ?>" alt="">
                <p>Home</p>
            </a>
            <a href="<?php echo e(route('user.investment.log')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\d6c4a41a832f1a3372d4d80ecfbd0ce3.png')); ?>" alt="">
                <p>Order</p>
            </a>
            <a href="<?php echo e(route('user.profile.setting')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\fa0eed652edb4df4c344aa74ef9328ac.png')); ?>" alt="">
                <p>Me</p>
            </a>

        </div>


    </body>

    <script>
        function submitWithdraw() {
            const button = $("#withdrawButton");
            button.prop("disabled", true);

            const methodCode = $("#withdrawMethodCode").val();
            const amount = $("#withdrawAmount").val();
            const balance = $("#withdrawBalance").val();



            $.ajax({
                url: "<?php echo e(route('user.withdraw.money')); ?>",
                method: "POST",
                data: {
                    method_code: methodCode,
                    amount: amount,
                    balance: balance,
                    _token: $('meta[name="csrf-token"]').attr("content")
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        window.location.href = "<?php echo e(route('user.withdraw')); ?>";
                    } else {
                        alert(response.error);
                        if (response.redirect_url) {
                            window.location.href = response.redirect_url;
                        }
                        button.prop("disabled", false);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation error from the controller
                        alert(xhr.responseJSON.error);
                    } else {
                        // General error

                        alert(xhr.responseJSON.error);
                        if (xhr.responseJSON.redirect_url) {
                            window.location.href = xhr.responseJSON.redirect_url;
                        }
                    }
                    button.prop("disabled", false);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/photowatt/core/resources/views/templates/basic/user/withdraw/methods.blade.php ENDPATH**/ ?>