<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('users/css/chunk-947ff9a0.19b6028a.css')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="<?php echo e(asset('static/tree/css/recharge.css')); ?>">

    <style>
        /* Card styling */
        .card {
            width: 350px;
            height: 200px;
            background: linear-gradient(135deg, green, rgb(10, 160, 10));
            border-radius: 15px;
            color: white;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            position: relative;
            font-size: 14px;
            margin: 0 auto;
        }

        /* Header with the bank logo */
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            font-size: 18px;
            font-weight: bold;
        }

        /* Card number section */
        .card-number {
            margin-top: 40px;
            font-size: 22px;
            letter-spacing: 2px;
            text-align: center;
        }

        /* Cardholder info section */
        .card-info {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }

        .cardholder, .expiration {
            font-size: 12px;
            text-transform: uppercase;
        }

        .cardholder span, .expiration span {
            font-weight: bold;
        }
    </style>

    <body>
        <div class="bank-wrap">
            <div class="navbar">
                <span onclick="onBack()">
                    <i></i>
                </span>
                <span>bank account</span>
                <span>
                </span>
            </div>
            <div class="tips-box">
                <img src="<?php echo e(asset('static/tree/img/err.png')); ?>" alt="">
                <p class="tips">
                    Please fill in your bank details to facilitate your withdrawal.
                </p>
            </div>


            <?php if(auth()->user()->bankAccount): ?>
            <?php
                $card_number = auth()->user()->bankAccount->account_number; // Example card number
                $formatted_card_number = wordwrap($card_number, 4, ' ', true); // Format with spaces
            ?>
            <span></span>


            <div class="card">
                <div class="card-header">
                    <div class="logo"><?php echo e(auth()->user()->bankAccount->bank_name); ?></div>
                </div>
                <div class="card-number">
                    <span><?php echo e($formatted_card_number); ?></span>
                </div>
                <div class="card-info">
                    <div class="cardholder">
                        <span><?php echo e(auth()->user()->bankAccount->account_name); ?></span>
                    </div>
                    <div class="expiration">
                        <span>xx/xx</span>
                    </div>
                </div>
            </div>


            <?php else: ?>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="list-wrap">
                        <ul class="uls">

                            <li>
                                <span>Bank Name</span>
                                <select class="val4" id="bank_ifsc"
                                    style="font-size: .30rem;height: 100%;border: none;margin-top: 20px;margin-bottom: 15px;"
                                    name="bank_code" id="bank_name">
                                    <option value="">Please choose your bank</option>
                                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($bank['bank_code']); ?>"><?php echo e($bank['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </li>

                            <li>
                                <span>Bank account</span>
                                <input type="text" class="account" placeholder="Please enter bank account"
                                    name="account_number" id="account" value="<?php echo e(auth()->user()->account_number); ?>">

                                <b class="close"></b>
                            </li>

                            <input type="hidden" name="bank_name" id="bank_code">

                            <li>
                                <span>Username</span>
                                <input type="text" name="account_name" id="account_name"
                                    placeholder="Please type your name" name="account_name"
                                    value="<?php echo e(auth()->user()->account_name); ?>">
                                <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p>
                                        <?php echo e($message); ?>

                                    </p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <b class="close"></b>
                            </li>



                        </ul>


                        <button type="submit" style="border: none; background: transparent; width: 100%;">
                            <div class="btn">send</div>
                        </button>


                    </div>
                </form>
            <?php endif; ?>


        </div>
    </body>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <textarea style="display: none;" id="all_banks"><?php echo $all_banks; ?></textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                //alert($(this).val());
                //let code = $("#bank_name").val(); //getByValue().bank_code;
                //let account = $("#account").val();

                //console.log(t, code);


                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                //console.log(code, account);

                let t = getByValue(code);

                //console.log(t);

                $("#bank_code").val(t);
                if (account != "" && code != "") {

                    get_account_info(code, account);

                    //console.log(account, code);
                }

            });

            $("#account").change(function() {

                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();
                if (account == "" || code == "") {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);

                //console.log(account, code);


            });





            function get_account_info(code, account) {

                $(".preloaders").show();
                $(".text-error").text("Fetching account details");

                $.ajax({
                    url: "<?php echo e(route('account.fetch')); ?>",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();
                            $(".text-error").text(
                                "Could not resolve account name, please check your account number or bank name and try again"
                            );
                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);

                        //console.log(response);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>

    <script>
        // Get the select element
        const bankSelect = document.getElementById('bank_name');
        // Get the input element
        const selectedBank = document.getElementById('bank_code');

        // Add event listener to the select element
        bankSelect.addEventListener('change', function() {
            // Get the selected option value
            const selectedOption = bankSelect.options[bankSelect.selectedIndex].text;
            // Update the value of the input field with the selected option value
            selectedBank.value = selectedOption;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/AMPPS/www/ipad/core/resources/views/templates/basic/user/bank-setup.blade.php ENDPATH**/ ?>