<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --page: #f7f2e9;
            --page2: #efe4d6;
            --panel: #fffaf2;
            --ink: #3b2613;
            --muted: #7a6a58;
            --line: rgba(0, 0, 0, .08);
            --shadow: 0 12px 28px rgba(184, 115, 51, .18);
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */

            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0
        }

        html,
        body {
            height: 100%
        }

        body {
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(900px 600px at 55% 8%, rgba(255, 255, 255, .7), rgba(255, 255, 255, .25) 60%, transparent 70%),
                linear-gradient(180deg, var(--page), var(--page2) 60%, var(--page));
            padding-bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        /* Header (optional brand strip if you add one later) */
        .top {
            position: sticky;
            top: 0;
            z-index: 6;
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            background: linear-gradient(180deg, #fff, var(--panel));
            border-bottom: 1px solid var(--line);
            box-shadow: var(--shadow);
            backdrop-filter: blur(10px);
        }

        .brand-logo {
            width: 34px;
            height: 34px;
            border-radius: 8px;
            object-fit: cover;
            background: #fff7ec;
            border: 1px solid var(--line)
        }

        .brand-title {
            font-weight: 900;
            letter-spacing: .2px;
            color: var(--accent)
        }

        .brand-title small {
            display: block;
            font-size: 11px;
            color: var(--muted);
            font-weight: 700
        }

        /* Tabs */
        .tabs {
            display: flex;
            justify-content: center;
            gap: 10px;
            width: 100%;
            max-width: 540px;
            margin: 10px auto 14px;
            padding: 0 14px;
        }

        .tab {
            flex: 1;
            text-align: center;
            padding: 10px 0;
            border-radius: 14px;
            cursor: pointer;
            font-weight: 900;
            background: linear-gradient(180deg, #ffffff, var(--panel));
            color: var(--muted);
            font-size: 13px;
            border: 1px solid var(--line);
            transition: all .2s;
            box-shadow: 0 6px 18px rgba(184, 115, 51, .12);
        }

        .tab.active {
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: white;
            border-color: transparent;
            box-shadow: 0 0 0 3px rgba(184, 115, 51, .18), 0 10px 24px rgba(214, 162, 94, .26);
        }

        /* Device cards */
        .device-container {
            padding: 0 14px;
            max-width: 540px;
            margin: 0 auto
        }

        .device-card {
            background: var(--panel);
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 14px;
            margin-bottom: 14px;
            box-shadow: var(--shadow);
            transition: transform .15s ease, box-shadow .15s ease;
        }

        .device-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 16px 32px rgba(184, 115, 51, .22);
        }

        .device-header {
            display: flex;
            align-items: center
        }

        .device-header img {
            width: 70px;
            height: 70px;
            border-radius: 12px;
            object-fit: cover;
            margin-right: 14px;
            background: #fff7ec;
            border: 1px solid var(--line)
        }

        .device-header .title {
            font-size: 16px;
            font-weight: 900
        }

        .device-header .subtitle {
            font-size: 12px;
            color: var(--accent);
            margin-top: 4px;
            font-weight: 800
        }

        .device-header .meta {
            font-size: 12px;
            color: var(--muted);
            margin-top: 2px
        }

        .info-table {
            font-size: 14px;
            margin-top: 10px;
            width: 100%;
            border-collapse: collapse
        }

        .info-table tr+tr td {
            border-top: 1px dashed var(--line)
        }

        .info-table td {
            padding: 8px 0
        }

        .info-label {
            color: var(--muted)
        }

        .info-value {
            text-align: right;
            font-weight: 900;
            color: var(--ink)
        }

        .info-value.emph {
            color: var(--accent)
        }

        .info-value.total {
            color: var(--accent2)
        }

        .action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 12px
        }

        .btn {
            padding: 10px 14px;
            border-radius: 12px;
            font-size: 13px;
            font-weight: 900;
            cursor: pointer;
            border: 1px solid var(--line);
            background: linear-gradient(180deg, #ffffff, var(--panel));
            color: var(--muted);
            transition: all .2s ease;
        }

        .btn-working {
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: white;
            border-color: transparent;
            box-shadow: 0 12px 26px rgba(214, 162, 94, .26);
        }

        .btn:hover {
            box-shadow: 0 8px 20px rgba(184, 115, 51, .22);
        }

        /* Bottom Tab Bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(8px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
            box-shadow: 0 -4px 16px rgba(184, 115, 51, .20);
        }

        .tabnav {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            transition: color .2s ease;
        }

        .tabnav .ico {
            width: 20px;
            height: 20px
        }

        .tabnav.active {
            color: var(--accent)
        }

        .tabnav.active .ico {
            color: var(--accent)
        }
    </style>


    <script>
        "use strict"

        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms * 1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " +
                    seconds + "s ";
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "COMPLETE";
                }
                tms--;
            }, 1000);
        }
    </script>


    <body>

        <!-- Tabs -->
        <div class="tabs">
            <div class="tab active" data-type="normal">Daily Coffee</div>
            
        </div>

        <!-- Device Cards -->
        <!-- Device Cards -->
        <div class="device-container">

            <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <!-- Device Card 1 -->
                <div class="device-card" data-type="normal">
                    <div class="device-header">
                        <img src="<?php echo e(asset('public/upload/package/1761154548R8Y.gif')); ?>" alt="Coffee">
                        <div>
                            <div class="title"><?php echo e($plan->plan->name); ?></div>
                            
                            <?php
                                $nextTime = \Carbon\Carbon::parse($plan->next_return_date);
                            ?>

                            <script>
                                createCountDown('counter<?php echo $plan->id; ?>', <?php echo e($nextTime->diffInSeconds()); ?>);
                            </script>

                            <div class="meta" id="counter<?php echo e($plan->id); ?>"></div>
                        </div>
                    </div>

                    <table class="info-table">
                        <tr>
                            <td class="info-label">Invested Amount</td>
                            <td class="info-value emph"><?php echo e($general->cur_sym); ?><?php echo e(number_format($plan->amount)); ?></td>
                        </tr>
                        <tr>
                            <td class="info-label">Daily Income</td>
                            <td class="info-value"><?php echo e($general->cur_sym); ?><?php echo e(number_format($plan->interest_amount)); ?></td>
                        </tr>
                        <tr>
                            <td class="info-label">Income Credited</td>
                            <td class="info-value total">
                                <?php echo e($general->cur_sym); ?><?php echo e($plan->total_paid * $plan->interest_amount); ?></td>
                        </tr>
                        <tr>
                            <td class="info-label">Total Income days</td>
                            <td class="info-value total">
                                <?php echo e($plan->total_return); ?> Days</td>
                        </tr>
                    </table>

                    
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <div style="text-align:center;padding:30px;">
                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Records"
                        style="width:90px;opacity:.9;margin-bottom:10px;">
                    <div style="color:var(--muted)">There are currently no records!</div>
                </div>
            <?php endif; ?>

            <!-- Device Card 2 -->
            <div class="device-card" data-type="fixed">
                <div class="device-header">
                    <img src="https://i.imgur.com/8uZxW7S.jpeg" alt="Coffee">
                    <div>
                        <div class="title">Hot Espresso</div>
                        <div class="subtitle">Hot Coffee</div>
                        <div class="meta">Updated 20 minutes ago</div>
                    </div>
                </div>

                <table class="info-table">
                    <tr>
                        <td class="info-label">Status</td>
                        <td class="info-value emph">Available</td>
                    </tr>
                    <tr>
                        <td class="info-label">Brew</td>
                        <td class="info-value">Strong</td>
                    </tr>
                    <tr>
                        <td class="info-label">Price</td>
                        <td class="info-value total">$3.20</td>
                    </tr>
                </table>

                <div class="action-buttons">
                    <div class="btn">Details</div>
                    <div class="btn btn-working">Order</div>
                </div>
            </div>

            <!-- No Records Message -->
            <div id="no-records" style="text-align:center;padding:30px;display:none;">
                <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Records"
                    style="width:90px;opacity:.9;margin-bottom:10px;">
                <div style="color:var(--muted)">There are currently no records!</div>
            </div>

        </div>




        <!-- Bottom Tab Bar -->
        <nav class="tabbar" role="navigation">
            <a class="tabnav <?php echo e(Request::is('user/dashboard') == true ? 'active' : ''); ?>" href="#"
                onclick="window.location.href='<?php echo e(route('user.home')); ?>'">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M12 3l9 8h-3v9h-5v-6H11v6H6v-9H3z"></path>
                </svg>
                <span>Home</span>
            </a>
            <a class="tabnav <?php echo e(Request::is('user/investment') == true ? 'active' : ''); ?>" href="#"
                onclick="window.location.href='<?php echo e(route('user.investment')); ?>'">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M4 4h16v6H4zM4 14h10v6H4zM16 14h4v6h-4z"></path>
                </svg>
                <span>Vip</span>
            </a>
            <a class="tabnav <?php echo e(Request::is('user/coupon') == true ? 'active' : ''); ?>" href="#"
                onclick="window.location.href='<?php echo e(route('user.coupon')); ?>'">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M12 2l3 7h7l-5.5 4.1L19 20l-7-4.5L5 20l2.5-6.9L2 9h7z"></path>
                </svg>
                <span>Bonus</span>
            </a>
            <a class="tabnav <?php echo e(Request::is('user/link') == true ? 'active' : ''); ?>" href="#"
                onclick="window.location.href='<?php echo e(route('user.link')); ?>'">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M18 8h-4V3H4a2 2 0 00-2 2v14l4-4h12a2 2 0 002-2V10a2 2 0 00-2-2z"></path>
                </svg>
                <span>Share</span>
            </a>
            <a class="tabnav <?php echo e(Request::is('user/profile-setting') == true ? 'active' : ''); ?>" href="#"
                onclick="window.location.href='<?php echo e(route('user.profile.setting')); ?>'">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                    <path d="M12 12a5 5 0 10-5-5 5 5 0 005 5zm0 2c-5 0-9 3-9 6v2h18v-2c0-3-4-6-9-6z"></path>
                </svg>
                <span>Mine</span>
            </a>
        </nav>

        <script>
            const tabs = document.querySelectorAll('.tab[data-type]');
            const cards = document.querySelectorAll('.device-card');

            function filterCards(type) {
                cards.forEach(card => {
                    card.style.display = (card.getAttribute('data-type') === type) ? 'block' : 'none';
                });
            }

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    tabs.forEach(t => t.classList.remove('active'));
                    tab.classList.add('active');
                    const type = tab.getAttribute('data-type').toLowerCase();
                    filterCards(type);
                });
            });

            window.addEventListener('DOMContentLoaded', () => {
                const activeTab = document.querySelector('.tab.active[data-type]');
                if (activeTab) {
                    filterCards(activeTab.getAttribute('data-type').toLowerCase());
                }
            });
        </script>

        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4d0f5c6ed3bda0&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/investment_log.blade.php ENDPATH**/ ?>