<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --a1: #b87333;
            /* caramel */
            --a2: #d6a25e;
            /* latte */
            --a3: #7a4a24;
            /* deep roast */
            --ink: #3b2613;
            /* text on light */
            --muted: #7a6a58;
            /* secondary text */
            --bg: #f7f2e9;
            /* paper background */
            --panel: #fffaf2;
            /* card */
            --line: rgba(0, 0, 0, .08);
            /* borders */
            --shadow: 0 12px 28px rgba(0, 0, 0, .10);
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0
        }

        html,
        body {
            height: 100%
        }

        body {
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--bg);
            display: flex;
            justify-content: center;
            padding: 20px 16px calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .dashboard {
            width: 100%;
            max-width: 540px
        }

        /* Header */
        .header {
            text-align: center;
            margin-bottom: 26px
        }

        .header h1 {
            font-size: 22px;
            font-weight: 900;
            color: var(--a1);
            letter-spacing: .3px;
            text-shadow: 0 1px 0 rgba(255, 255, 255, .6)
        }

        .header p {
            color: var(--muted);
            font-size: 13px;
            margin-top: 4px;
            font-weight: 600
        }

        /* Gift Card */
        .gift-card {
            background: linear-gradient(180deg, #ffffff, #fff4e8);
            border: 1px solid var(--line);
            border-radius: 20px;
            padding: 24px 20px 30px;
            box-shadow: var(--shadow);
            text-align: center;
        }

        .gift-card h2 {
            font-weight: 900;
            font-size: 18px;
            margin-bottom: 18px;
            color: var(--a1);
            letter-spacing: .3px;
        }

        .input-group {
            display: flex;
            align-items: center;
            gap: 8px;
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1.5px solid var(--line);
            border-radius: 12px;
            padding: 12px 14px;
            margin-bottom: 18px;
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, .06);
            transition: all .2s ease;
        }

        .input-group:focus-within {
            border-color: var(--a2);
            box-shadow: 0 0 0 3px rgba(214, 162, 94, .18);
        }

        .input-group input {
            flex: 1;
            border: none;
            outline: none;
            font-weight: 800;
            font-size: 16px;
            text-transform: uppercase;
            letter-spacing: .1em;
            background: transparent;
            color: var(--ink);
        }

        .redeem-btn {
            width: 100%;
            border: none;
            border-radius: 14px;
            padding: 14px;
            font-weight: 900;
            font-size: 16px;
            color: #fff;
            cursor: pointer;
            background: linear-gradient(90deg, var(--a1), var(--a2));
            box-shadow: 0 10px 20px rgba(184, 115, 51, .22);
            transition: all .2s ease;
        }

        .redeem-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 14px 28px rgba(184, 115, 51, .28);
        }

        .note {
            margin-top: 14px;
            color: var(--muted);
            font-size: 13px;
        }

        .response-message {
            margin-top: 10px;
            font-weight: 800;
            color: var(--a3);
            display: none;
        }

        /* Popup */
        .popup {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, .25);
            align-items: center;
            justify-content: center;
            z-index: 60;
        }

        .popup-card {
            background: linear-gradient(180deg, #ffffff, #fff4e7);
            border-radius: 16px;
            padding: 22px;
            width: min(92%, 360px);
            text-align: center;
            box-shadow: 0 24px 60px rgba(0, 0, 0, .18);
            border: 1px solid var(--line);
            color: var(--ink);
        }

        .popup-card h3 {
            font-size: 20px;
            color: var(--a1);
            margin-bottom: 8px;
        }

        .popup-card p {
            font-weight: 800;
        }

        /* Tabbar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(8px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            padding: 10px 0;
            transition: color .2s;
        }

        .tab .ico {
            width: 20px;
            height: 20px;
            color: var(--muted);
            transition: color .2s
        }

        .tab.active {
            color: var(--a1)
        }

        .tab.active .ico {
            color: var(--a1)
        }

        .tab:hover {
            color: var(--a2)
        }

        .tab:hover .ico {
            color: var(--a2)
        }
    </style>



    <body>
        <div class="dashboard">
            <div class="header">
                <h1>Gift Code</h1>
                <p>Enter your bonus code to claim your reward.</p>
            </div>

            <div class="gift-card">
                <h2>Redeem Bonus</h2>

                <div class="input-group">
                    <input id="gift-code" type="text" placeholder="Code" aria-label="Gift code" />
                </div>

                <button class="redeem-btn" onclick="submitBonus()">Redeem Code</button>

                <div class="response-message" id="response"></div>
                <p class="note">Your bonus will reflect in your balance shortly.</p>
            </div>
        </div>

        <!-- Popup -->
        <div class="popup" id="bonusPopup">
            <div class="popup-card">
                <h3>🎉 Success!</h3>
                <p id="bonusMessage">You’ve successfully received your bonus!</p>
            </div>
        </div>

        <!-- Bottom Tab Bar -->
        <?php echo $__env->make('templates.basic.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            function showPopup(message) {
                document.getElementById('bonusMessage').innerText = message;
                const popup = document.getElementById('bonusPopup');
                popup.style.display = 'flex';
                setTimeout(() => popup.style.display = 'none', 2500);
            }

            function submitBonus() {
                const code = document.getElementById('gift-code').value.trim();
                const response = document.getElementById('response');
                if (!code) {
                    response.innerText = '⚠️ Please enter your gift code.';
                    response.style.display = 'block';
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('user.redeem')); ?>",
                    method: 'POST',
                    dataType: 'json',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        code: code
                    },

                    success: function(res) {
                        response.innerText = res.message;
                        response.style.display = 'block';

                        if (res.success && res.amount) {
                            showPopup(`You’ve received <?php echo e($general->cur_sym); ?>${Number(res.amount).toFixed(2)} bonus!`);
                        } else {
                            showPopup(res.message);
                        }
                    },

                    error: function(xhr) {
                        let msg = "Something went wrong.";

                        if (xhr.status === 422) {
                            msg = xhr.responseJSON.errors.code ?
                                xhr.responseJSON.errors.code[0] :
                                "Invalid code.";
                        }

                        response.innerText = msg;
                        response.style.display = 'block';
                    }
                });
            }
        </script>
        <script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon='{"rayId":"9a4cc5fe88c47a91","version":"2025.9.1","r":1,"token":"4ab13e381f7c42dfab5a793122eabacc","serverTiming":{"name":{"cfExtPri":true,"cfEdge":true,"cfOrigin":true,"cfL4":true,"cfSpeedBrain":true,"cfCacheStatus":true}}}'
            crossorigin="anonymous"></script>
    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/coupon.blade.php ENDPATH**/ ?>