<?php $__env->startSection('content'); ?>
    <link href="<?php echo e(asset('css/cardInfo.css')); ?>" rel="stylesheet" type="text/css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <body class="addbankcardPage addDccessPage">
        <div class="app h5MaxWidth">
            <header>
                <div class="header h5MaxWidth clear display alignCenter">
                    <div class="back display alignCenter" onclick="jumpLink('-1',9)">
                        <i class="iconfont icon-arrow-left"></i>
                    </div>
                    <h3 class="flex1">Add Bank Account</h3>
                    <div class="navskip" id="sideMenu"></div>
                </div>
            </header>

            <div class="main">
                <div class="addbankcard radius15PX forms">
                    <form id="addbankcard" action="#" method="post">
                        <?php echo csrf_field(); ?>
                        <ul>
                            <li id="openBankList">
                                <div class="formTitleBar">
                                    <h4>Bank</h4>
                                </div>
                                <div class="linearFrame inputArea display alignCenter">
                                    <div class="trueInpt display alignCenter flex1">
                                        <div class="leftSideBox display alignCenter">
                                            <div class="bankIcon">
                                                <img src="<?php echo e(asset('img/Chip.svg')); ?>" alt="" />
                                            </div>
                                        </div>
                                        <select type="text" name="bank_code" id="bank_name"
                                            class="cardBankName fillArea flex1" required data-country="" />
                                        <option value="">Please select the bank.</option>
                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($bank['bank_code']); ?>"><?php echo e($bank['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </li>
                            <li class="bankIFSCBox" style="display: none;">
                                <div class="formTitleBar">
                                    <h4>Bank IFSC</h4>
                                </div>
                                <div class="linearFrame inputArea display alignCenter">
                                    <div class="trueInpt display alignCenter flex1">
                                        <input type="text" name="bankIFSC" id="bankIFSC" class="bankIFSC fillArea flex1"
                                            placeholder="Please enter the bank IFSC code." />
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="formTitleBar">
                                    <h4>Bank Account Number</h4>
                                </div>
                                <div class="linearFrame inputArea display alignCenter">
                                    <div class="trueInpt display alignCenter flex1">
                                        <input type="number" name="account_number" id="account"
                                            class="cardNo fillArea flex1" placeholder="Bank Account Number" maxlength="30"
                                            size="30" required />
                                    </div>
                                </div>
                            </li>
                            <span style="color:
                            red;"
                                class="text-danger text-error block"></span>

                            <input type="hidden" style="border: solid 1px #c65102;" name="bank_name" id="bank_code">
                            <li>
                                <div class="formTitleBar">
                                    <h4>Cardholder Name</h4>
                                </div>
                                <div class="linearFrame inputArea display alignCenter">
                                    <div class="trueInpt display alignCenter flex1">
                                        <input type="text" name="account_name" id="account_name" class="userName fillArea flex1"
                                            placeholder="Cardholder name" required/>
                                    </div>
                                </div>
                            </li>

                        </ul>
                        <div class="actionBar display alignCenter alignStretch">
                            <button type="submit" class="submitBinding flex1 clickBtn display alignCenter justifyCenter">
                                <p>Confirm</p>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="tipsBox">
                    <div id="tips" class="tips">
                        <div class="titleBar display alignCenter">
                            <h3>Explain</h3>
                        </div>
                        <div class="explain">
                            <p>1. Please carefully verify if the bank account information is correct.</p>
                            <p>2. If you need to change your withdrawal bank account, please reset it through Verification
                                Code (OTP).</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </body>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <textarea style="display: none;" id="all_banks"><?php echo $all_banks; ?></textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                //alert($(this).val());
                //let code = $("#bank_name").val(); //getByValue().bank_code;
                //let account = $("#account").val();

                //console.log(t, code);


                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                //console.log(code, account);

                let t = getByValue(code);

                //console.log(t);

                $("#bank_code").val(t);
                if (account != "" && code != "") {

                    get_account_info(code, account);

                    //console.log(account, code);
                }

            });

            $("#account").change(function() {

                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();
                if (account == "" || code == "") {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);

                //console.log(account, code);


            });





            function get_account_info(code, account) {

                $(".preloaders").show();
                $(".text-error").text("Fetching account details");

                $.ajax({
                    url: "<?php echo e(route('account.fetch')); ?>",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();
                            $(".text-error").text(
                                "Could not resolve account name, please check your account number or bank name and try again"
                            );
                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);

                        //console.log(response);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>

    <script>
        // Get the select element
        const bankSelect = document.getElementById('bank_name');
        // Get the input element
        const selectedBank = document.getElementById('bank_code');

        // Add event listener to the select element
        bankSelect.addEventListener('change', function() {
            // Get the selected option value
            const selectedOption = bankSelect.options[bankSelect.selectedIndex].text;
            // Update the value of the input field with the selected option value
            selectedBank.value = selectedOption;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/AMPPS/www/olam/core/resources/views/templates/basic/user/bank-setup.blade.php ENDPATH**/ ?>