<?php $__env->startSection('content'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="<?php echo e(asset('static/index/v1/css/card.css')); ?>">

    <body>
        <div class="headerbg flex_be">
            <div class="flex_sta">
                <img class="back" src="<?php echo e(asset('uploads/material/back.png')); ?>" alt="">
                <p class="pagetitle">Bank Card Info</p>
            </div>
            <div class="flex_sta icons">
                <a href="<?php echo e(route('user.referrals')); ?>"><img src="<?php echo e(asset('uploads/material/toteamicon.png')); ?>"
                        alt=""></a>
                <a class="sharebutton"><img src="<?php echo e(asset('uploads/material/toshareicon.png')); ?>" alt=""></a>
            </div>
        </div>



        <a href="<?php echo e($general->telegram_chat_id); ?>" class="kfimg" style="z-index: 999">
            <img src="<?php echo e(asset('uploads/material/kf.png')); ?>" alt="">
        </a>

        <div class="cardinfo centeritem">
            <img class="cardbg" src="<?php echo e(asset('uploads/material/cardbg.png')); ?>" alt="">
            <div class="cardcontent">
                <div class="flex_sta totaltitle">
                    <img src="<?php echo e(asset('uploads/material/cardcoin.png')); ?>" alt="">
                    <p>Total Balance</p>
                </div>
                <h6><?php echo e($general->cur_sym); ?><?php echo e(number_format($user->bonus_balance)); ?></h6>
                <div class="please flex_sta">
                    <img src="<?php echo e(asset('uploads/material/cardgreen.png')); ?>" alt="">
                    <div>
                        <span>Please bind your bank card first</span>
                        <p>Bank Account</p>
                    </div>
                </div>
            </div>
        </div>
        <form action="" method="post">
            <?php echo csrf_field(); ?>
            <div class="detaillist">
                <p class="modaltitle">Bank Card Info</p>
                <span class="lable">Account Holder's Name</span>
                <div class="flex_sta inputbox">
                    <input type="text" name="account_name" id="account_name" placeholder="Enter account holder's name" required>
                </div>
                <span class="lable">Bank Name</span>
                <div class="inputbox flex_be">
                    <select name="bank_code" id="bank_name" required>
                        <option value="134">Access Bank</option>
                        <option value="135">Access Bank (Diamond)</option>
                        <option value="136">Ecobank Nigeria</option>
                        <option value="137">First City Monument Bank</option>
                        <option value="138">Fidelity Bank</option>
                        <option value="139">First Bank of Nigeria</option>
                        <option value="140">Guaranty Trust Bank</option>
                        <option value="141">Heritage Bank</option>
                        <option value="142">Jaiz Bank</option>
                        <option value="143">Keystone Bank</option>
                        <option value="144">Stanbic IBTC Bank</option>
                        <option value="145">Sterling Bank</option>
                        <option value="146">United Bank For Africa</option>
                        <option value="147">Union Bank of Nigeria</option>
                        <option value="148">Unity Bank</option>
                        <option value="149">Wema Bank</option>
                        <option value="150">Zenith Bank</option>
                        <option value="151">Abbey Mortgage Bank</option>
                        <option value="152">ALAT by WEMA</option>
                        <option value="153">ASO Savings and Loans</option>
                        <option value="154">Bowen Microfinance Bank</option>
                        <option value="155">CEMCS Microfinance Bank</option>
                        <option value="156">CitiBank Nigeria</option>
                        <option value="157">Coronation Merchant Bank</option>
                        <option value="158">Ekondo Microfinance Bank</option>
                        <option value="159">Eyowo</option>
                        <option value="160">SDH Merchant Bank Limited</option>
                        <option value="161">Globus Bank</option>
                        <option value="162">Hackman Microfinance Bank</option>
                        <option value="163">Hasal Microfinance Bank</option>
                        <option value="164">Ibile Microfinance</option>
                        <option value="165">Infinity MFB</option>
                        <option value="166">Kuda Bank</option>
                        <option value="167">Lagos Building Investment Company Plc</option>
                        <option value="168">Mayfair MFB</option>
                        <option value="169">One Finance</option>
                        <option value="170">PalmPay</option>
                        <option value="171">Parallex Bank</option>
                        <option value="172">Parkway - ReadyCash</option>
                        <option value="173">Paycom</option>
                        <option value="174">Petra Mircofinance Bank Plc</option>
                        <option value="175">Polaris Bank</option>
                        <option value="176">Providus Bank</option>
                        <option value="177">Rubies MFB</option>
                        <option value="178">Sparkle Microfinance Bank</option>
                        <option value="179">Standard Chartered Bank</option>
                        <option value="180">Suntrust Bank</option>
                        <option value="181">TAJ Bank</option>
                        <option value="182">TCF MFB</option>
                        <option value="183">Titan Bank</option>
                        <option value="184">VFD Microfinance Bank</option>
                    </select>
                    <img class="selecticon" src="<?php echo e(asset('uploads/material/select1.png')); ?>" alt="">
                </div>
                <input type="hidden" name="bank_name" id="bank_code">
                <span class="lable">Bank Account</span>
                <div class="flex_sta inputbox">
                    <input class="check_number_func_1" type="text" beforeval="" name="account_number" id="account"
                        placeholder="Enter bank account" required>
                </div>
                <button style="border:none" type="submit" class="submit">Submit</button>
            </div>
        </form>
        <div class="footer flex_be">
            <a href="<?php echo e(route('user.home')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\f009397ad7700e00d7a6d8189fefe4d3.png')); ?>" alt="">
                <p>Home</p>
            </a>
            <a href="<?php echo e(route('user.investment.log')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\d6c4a41a832f1a3372d4d80ecfbd0ce3.png')); ?>" alt="">
                <p>Order</p>
            </a>
            <a href="<?php echo e(route('user.profile.setting')); ?>">
                <img src="<?php echo e(asset('uploads\material\20250411\fa0eed652edb4df4c344aa74ef9328ac.png')); ?>" alt="">
                <p>Me</p>
            </a>

        </div>


    </body>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <textarea style="display: none;" id="all_banks"><?php echo $all_banks; ?></textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                //alert($(this).val());
                //let code = $("#bank_name").val(); //getByValue().bank_code;
                //let account = $("#account").val();

                //console.log(t, code);


                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                //console.log(code, account);

                let t = getByValue(code);

                //console.log(t);

                $("#bank_code").val(t);
                if (account != "" && code != "") {

                    get_account_info(code, account);

                    //console.log(account, code);
                }

            });

            $("#account").change(function() {

                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();
                if (account == "" || code == "") {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);

                //console.log(account, code);


            });





            function get_account_info(code, account) {

                $(".preloaders").show();

                $.ajax({
                    url: "<?php echo e(route('account.fetch')); ?>",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();

                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);

                        //console.log(response);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>

    <script>
        // Get the select element
        const bankSelect = document.getElementById('bank_name');
        // Get the input element
        const selectedBank = document.getElementById('bank_code');

        // Add event listener to the select element
        bankSelect.addEventListener('change', function() {
            // Get the selected option value
            const selectedOption = bankSelect.options[bankSelect.selectedIndex].text;
            // Update the value of the input field with the selected option value
            selectedBank.value = selectedOption;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/photowatt/core/resources/views/templates/basic/user/bank-setup.blade.php ENDPATH**/ ?>