<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* Coffeehouse palette */
            --ink: #3b2613;
            --muted: #7a6a58;
            --bg: #f7f2e9;
            --panel: #fffaf2;
            --panel-2: #f3e7d8;
            --line: rgba(0, 0, 0, .08);
            --ring: #e9dcc7;
            --accent: #b87333;
            --accent2: #d6a25e;
            --danger: #ff5a5f;
            --tabbar-h: 66px;
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            color: var(--ink);
            font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--bg);
            display: flex;
            justify-content: center;
        }

        .app {
            width: 100%;
            max-width: 560px;
            min-height: 100dvh;
            display: flex;
            flex-direction: column;
            padding-bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 16px);
        }

        /* ===== Hero Header (coffee style) ===== */
        .hero {
            position: relative;
            padding: 0 14px;
            margin-top: 10px;
        }

        .badge-head {
            position: relative;
            height: 200px;
            display: grid;
            place-items: center;
            background:
                radial-gradient(320px 130px at 50% 28%, rgba(214, 162, 94, .25), transparent 70%),
                linear-gradient(180deg, rgba(255, 255, 255, .9), rgba(245, 238, 226, .7));
            border-radius: 18px;
            box-shadow: 0 10px 28px rgba(59, 38, 19, .12);
            overflow: hidden;
        }

        .brand {
            position: absolute;
            top: 16px;
            width: 100%;
            display: flex;
            justify-content: center;
            font-weight: 900;
            letter-spacing: 1px;
            font-size: 18px;
            color: #5a3a1d;
            text-shadow: 0 1px 0 rgba(255, 255, 255, .65);
            pointer-events: none;
        }

        .badge {
            width: 180px;
            height: 180px;
            border-radius: 50%;
            background:
                radial-gradient(circle at 50% 50%, #f6efe3 0 35%, transparent 36%),
                radial-gradient(circle at 50% 50%, #f0e4d1 0 58%, transparent 59%),
                radial-gradient(circle at 50% 50%, #ead8bf 0 74%, transparent 75%);
            box-shadow:
                0 0 0 6px var(--ring),
                0 0 0 12px #e3d3b7,
                inset 0 0 0 2px rgba(255, 255, 255, .6),
                0 10px 22px rgba(0, 0, 0, .08);
        }

        .plane {
            position: absolute;
            inset: 0;
            display: grid;
            place-items: center;
            pointer-events: none
        }

        .plane svg {
            width: 220px;
            height: auto;
            transform: translateY(-6px);
            filter: drop-shadow(0 8px 12px rgba(0, 0, 0, .12));
        }

        .plate {
            position: absolute;
            bottom: 12px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            border-radius: 12px;
            padding: 8px 16px;
            box-shadow: 0 6px 16px rgba(184, 115, 51, .22);
            border: 1px solid rgba(255, 255, 255, .25);
            font-weight: 900;
            letter-spacing: .6px;
            font-size: 18px;
            color: #fff;
        }

        /* ===== Flash ===== */
        .message-container {
            position: sticky;
            top: 0;
            z-index: 20;
            padding: 8px 14px
        }

        .message-box {
            background: linear-gradient(180deg, #fff7ea, #fdeccf);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 10px 12px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, .06)
        }

        .success {
            color: var(--accent);
            margin: 0;
            font-weight: 700
        }

        .error {
            color: #b24141;
            margin: 0;
            font-weight: 700
        }

        /* ===== Tabs ===== */
        .cloud-section {
            padding: 6px 14px 0
        }

        .tabs {
            display: flex;
            align-items: center;
            gap: 8px;
            background: linear-gradient(180deg, #ffffff, #fff6e9);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 8px;
            box-shadow: 0 8px 18px rgba(0, 0, 0, .06);
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .tabs::-webkit-scrollbar {
            display: none;
        }

        .tab-btn {
            flex: 0 0 auto;
            padding: 10px 12px;
            border-radius: 10px;
            background: transparent;
            color: var(--muted);
            border: 0;
            font-weight: 800;
            letter-spacing: .2px;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            white-space: nowrap;
        }

        .tab-btn.active {
            color: #fff;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            box-shadow: 0 6px 16px rgba(184, 115, 51, .22)
        }

        .divider {
            width: 1px;
            height: 24px;
            background: var(--line)
        }

        .hot-badge {
            display: inline-block;
            padding: 6px 10px;
            border-radius: 999px;
            font-weight: 900;
            letter-spacing: .2px;
            color: #fff;
            background: linear-gradient(90deg, #ff6a6f, #ff3b3f);
            box-shadow: 0 6px 16px rgba(255, 59, 63, .35)
        }

        /* Month Special tab icon */
        .tab-btn.month::before {
            content: "🎉";
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            filter: drop-shadow(0 2px 6px rgba(0, 0, 0, .25));
        }

        /* Month Special button layout + LIVE tag */
        .tab-btn.month {
            padding-left: 32px;
            padding-right: 46px;
            position: relative;
        }

        /* Animated LIVE pill */
        .tab-btn .live-tag {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 10px;
            font-weight: 900;
            padding: 3px 7px;
            border-radius: 999px;
            letter-spacing: .8px;
            background: linear-gradient(90deg, #ff3b3f, #ff9a3b);
            color: #fff;
            text-shadow: 0 0 6px rgba(0, 0, 0, .25);
            box-shadow: 0 0 0 0 rgba(255, 59, 63, .65);
            animation: livePulse 1.1s infinite ease-out;
        }

        /* Pulse animation for LIVE text */
        @keyframes  livePulse {
            0% {
                transform: translateY(-50%) scale(1);
                box-shadow: 0 0 0 0 rgba(255, 59, 63, .7);
                opacity: 1;
            }

            60% {
                transform: translateY(-50%) scale(1.05);
                box-shadow: 0 0 0 8px rgba(255, 59, 63, 0);
                opacity: 1;
            }

            100% {
                transform: translateY(-50%) scale(1);
                box-shadow: 0 0 0 0 rgba(255, 59, 63, 0);
                opacity: 1;
            }
        }

        /* ===== Plans grid ===== */
        .plan-container {
            padding: 14px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 14px;
            padding-bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 24px);
        }

        article.card {
            border-radius: 18px;
            overflow: hidden;
            background: linear-gradient(180deg, #ffffff, #fff9f0);
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 8px 18px rgba(0, 0, 0, .05);
            position: relative;
            cursor: pointer;
            transition: transform .08s ease, box-shadow .2s ease;
        }

        article.card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .12)
        }

        .thumb {
            width: 100%;
            height: 122px;
            object-fit: cover;
            display: block;
            background: #fff3e2
        }

        .card-details {
            padding: 10px 12px 12px
        }

        .card-title {
            margin: 0 0 6px;
            font-size: 14px;
            font-weight: 800;
            color: #5a3a1d;
        }

        .card-price {
            font-weight: 900;
            color: var(--accent);
            margin-bottom: 8px
        }

        /* 25% cashback badge */
        .cashback-badge {
            display: inline-block;
            margin-bottom: 6px;
            padding: 3px 9px;
            border-radius: 999px;
            font-size: 11px;
            font-weight: 800;
            letter-spacing: .3px;
            color: var(--danger);
            background: rgba(255, 90, 95, .08);
            border: 1px dashed rgba(255, 90, 95, .4);
        }

        .info {
            display: grid;
            gap: 4px;
            font-size: 12px;
            color: var(--muted)
        }

        .row {
            display: flex;
            justify-content: space-between;
            gap: 8px
        }

        .row .v {
            color: var(--ink);
            font-weight: 700
        }

        .arrow {
            position: absolute;
            right: 10px;
            bottom: 10px;
            font-size: 18px;
            color: var(--muted)
        }

        /* ===== Month Special monthly celebration styling ===== */
        #month-special {
            position: relative;
            background:
                linear-gradient(180deg, rgba(247, 242, 233, .96), rgba(247, 242, 233, .96)),
                url('https://i.pinimg.com/originals/d0/09/67/d009678eb5b1658468704f51bfc11173.gif') center/cover no-repeat;
        }

        #month-special article.card {
            background: rgba(255, 250, 242, .96);
            border: 1px solid rgba(184, 115, 51, .35);
            box-shadow: 0 10px 26px rgba(184, 115, 51, .25);
        }

        #month-special .card-title {
            color: #5a3a1d;
        }

        /* ===== Popup ===== */
        .popup {
            display: none;
            place-items: center;
            position: fixed;
            inset: 0;
            z-index: 50;
            background: rgba(0, 0, 0, .55);
            padding: 18px
        }

        .popup-content {
            width: min(480px, 100%);
            background: linear-gradient(180deg, #ffffff, #fff6e9);
            border: 1px solid rgba(0, 0, 0, .06);
            border-radius: 18px;
            box-shadow: 0 24px 60px rgba(0, 0, 0, .25);
            overflow: hidden;
            position: relative;
        }

        .close-btn {
            position: absolute;
            margin: 10px 12px;
            right: 0;
            top: 0;
            font-size: 28px;
            cursor: pointer;
            color: #5a3a1d;
        }

        .popup-content img {
            width: 100%;
            height: 180px;
            object-fit: cover;
            display: block;
            background: #fff3e2
        }

        .popup-title {
            padding: 12px 14px 0;
            font-size: 18px;
            font-weight: 900;
            color: #5a3a1d;
        }

        .price-info {
            display: flex;
            justify-content: space-between;
            gap: 12px;
            padding: 8px 14px 0
        }

        .price-info .left {
            font-weight: 900;
            color: var(--accent)
        }

        .price-info .right {
            font-weight: 900;
            color: #5a3a1d
        }

        .parameters {
            padding: 12px 14px;
            display: grid;
            gap: 8px;
            font-size: 14px
        }

        .parameters .label {
            color: var(--muted)
        }

        .parameters .value {
            font-weight: 800;
            color: var(--ink)
        }

        .popup-description {
            padding: 0 14px 14px;
            color: var(--muted)
        }

        .confirm-btn {
            width: calc(100% - 28px);
            margin: 8px 14px 14px;
            border: 0;
            cursor: pointer;
            border-radius: 14px;
            padding: 14px 16px;
            color: #fff;
            font-weight: 900;
            font-size: 16px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            box-shadow: 0 10px 26px rgba(184, 115, 51, .22)
        }

        /* ===== Tabbar ===== */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 560px;
            height: var(--tabbar-h);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-top: 1px solid rgba(0, 0, 0, .06);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            padding-bottom: env(safe-area-inset-bottom);
            z-index: 45;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent)
        }

        .tab.active .ico {
            color: var(--accent)
        }

        /* ===== Floating Support ===== */
        .support {
            position: fixed;
            right: 16px;
            bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 18px);
            z-index: 40;
            width: 54px;
            height: 54px;
            border-radius: 50%;
            display: grid;
            place-items: center;
            color: #fff;
            text-decoration: none;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            box-shadow: 0 14px 30px rgba(184, 115, 51, .22)
        }

        .toast {
            position: fixed;
            left: 50%;
            bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 14px);
            transform: translateX(-50%);
            background: rgba(255, 255, 255, .95);
            color: var(--ink);
            border: 1px solid rgba(0, 0, 0, .08);
            padding: 10px 14px;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(184, 115, 51, .18);
            display: none;
            z-index: 60;
            font-size: 13px;
            font-weight: 800;
        }

        @media (max-width:380px) {
            .plan-container {
                grid-template-columns: 1fr
            }

            .thumb {
                height: 110px
            }
        }
    </style>

    <body>
        <div class="app">




            <!-- HERO -->
            <section class="hero">
                <div class="badge-head" aria-hidden="true">
                    <div class="brand">Blend Beans</div>
                    <div class="badge"></div>
                    <div class="plane">
                        <!-- Coffee cup + steam emblem -->
                        <svg viewBox="0 0 200 200" fill="none" aria-hidden="true">
                            <!-- steam -->
                            <path d="M112 52c14 10 8 22-2 27m-14-9c11 6 6 15-1 19" stroke="#b87333" stroke-width="6"
                                stroke-linecap="round"></path>
                            <!-- cup -->
                            <path d="M70 86h64c2 26-16 46-46 46s-32-20-30-46z" fill="#fff"></path>
                            <path d="M70 86h64c2 26-16 46-46 46s-32-20-30-46z" stroke="#7a4a24" stroke-width="4"></path>
                            <!-- handle -->
                            <path d="M144 99c14-2 20 6 18 14-2 10-12 14-22 10" stroke="#7a4a24" stroke-width="4"
                                fill="none"></path>
                            <!-- bean -->
                            <ellipse cx="94" cy="96" rx="12" ry="9" fill="#5a361f"></ellipse>
                            <path d="M88 93c4 3 10 3 12 8" stroke="#d6a25e" stroke-width="2" stroke-linecap="round"></path>
                        </svg>
                    </div>
                    <div class="plate">Since 1972</div>
                </div>
            </section>

            <!-- TABS -->
            <div class="cloud-section">
                <div class="tabs">
                    <button class="tab-btn active" onclick="showTab('daily', this)">Daily coffee</button>
                    <div class="divider"></div>
                    
                </div>
            </div>

            <!-- DAILY (NORMAL) — excludes 109–113 and Month Special IDs -->
            <div class="plan-container tab-content" id="daily" style="display:grid">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="card"
                        onclick="openPopup({
          name: &quot;<?php echo e($plan->name); ?>&quot;,
          daily: &quot;\u20b1<?php echo e($plan->interest_amount); ?>&quot;,
          total: &quot;\u20b1<?php echo e(number_format($plan->total_return * $plan->interest_amount)); ?>&quot;,
          cycle: <?php echo e($plan->total_return); ?>,
          price: &quot;\u20b1<?php echo e(number_format($plan->min_amount)); ?>&quot;,
          imgUrl: &quot;<?php echo e(asset('public/upload/package/1761154548R8Y.gif')); ?>&quot;,
          url: &quot;<?php echo e(url('user/investment/purchase/confirmation/'.$plan->id)); ?>&quot;        })">
                        <img class="thumb" src="<?php echo e(asset('public/upload/package/1761154548R8Y.gif')); ?>"
                            alt="<?php echo e($plan->name); ?>">
                        <div class="card-details">
                            <h3 class="card-title"><?php echo e($plan->name); ?></h3>
                            <div class="card-price"><?php echo e($general->cur_sym); ?><?php echo e(number_format($plan->min_amount)); ?></div>
                            <div class="info">
                                <div class="row"><span>Profit</span><span class="v"><?php echo e($general->cur_sym); ?><?php echo e($plan->interest_amount); ?> / <?php echo e($plan->interest_hours); ?>h</span></div>
                                <div class="row"><span>Total profit</span><span class="v"><?php echo e(number_format($plan->total_return * $plan->interest_amount)); ?></span></div>
                                <div class="row"><span>Validity</span><span class="v"><?php echo e($plan->total_return); ?> days</span></div>
                            </div>
                        </div>
                        <div class="arrow">›</div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- FIXED (HOT) — excludes 109–113, Month Special, Month Lk Special -->
            

            <!-- MONTH SPECIAL — ONLY plan IDs 118,119,120,125 + 25% cashback -->
            

            <!-- MONTH LK SPECIAL — ONLY fixed plans 121,122,123,124 + 25% cashback -->
            

            <!-- Support -->
            <a class="support" href="<?php echo e($general->telegram_group); ?>">
                <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                    <path
                        d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8zm-1 17h2v3h-2z">
                    </path>
                </svg>
            </a>
        </div>

        <!-- Popup -->
        <div class="popup" id="popup">
            <div class="popup-content">
                <div class="close-btn" onclick="closePopup()">×</div>
                <img id="popup-img" src="" alt="Plan">
                <div class="popup-title" id="popup-title"></div>
                <div class="price-info">
                    <div class="left" id="popup-price">--</div>
                    <div class="right" id="popup-return">--</div>
                </div>
                <div class="parameters">
                    <div><span class="label">Profit</span><span class="value" id="popup-daily"></span></div>
                    <div><span class="label">Total profit</span><span class="value" id="popup-total"></span></div>
                    <div><span class="label">Validity</span><span class="value" id="popup-cycle"></span></div>
                    
                </div>
                <div class="popup-description">
                    Are you sure you want to purchase this plan? Click <b>Buy Now</b>. This plan runs for <b
                        id="popup-cycle-bottom"></b> days.
                </div>
                <button id="popup-invest-btn" class="confirm-btn">Buy Now</button>
            </div>
        </div>

        <!-- Tabbar -->
        <?php echo $__env->make('templates.basic.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script>
            function showTab(tab, el) {
                // switch panels
                document.querySelectorAll('.tab-content').forEach(x => x.style.display = 'none');
                const panel = document.getElementById(tab);
                if (panel) panel.style.display = 'grid';

                // active tab highlight
                document.querySelectorAll('.tab-btn').forEach(x => x.classList.remove('active'));
                (el && el.closest('button') ? el.closest('button') : el).classList.add('active');

                // toast messages
                if (tab === 'month-special') {
                    showToast('🎉 Month Special — monthly celebration plans are now live with 25% cashback!');
                }
                if (tab === 'month-lk-special') {
                    showToast('☕ Month Lk Special — fixed plans with 25% cashback!');
                }
            }

            function showToast(text) {
                let t = document.querySelector('.toast');
                if (!t) {
                    t = document.createElement('div');
                    t.className = 'toast';
                    document.body.appendChild(t);
                }
                t.textContent = text;
                t.style.display = 'block';
                clearTimeout(window.__toastTimer);
                window.__toastTimer = setTimeout(() => {
                    t.style.display = 'none';
                }, 2500);
            }

            function openPopup(o) {
                const {
                    name,
                    daily,
                    total,
                    cycle,
                    price,
                    imgUrl,
                    url
                } = o;
                const popup = document.getElementById('popup');
                popup.style.display = 'grid';
                document.body.style.overflow = 'hidden';
                document.getElementById('popup-title').textContent = name;
                document.getElementById('popup-img').src = imgUrl;
                document.getElementById('popup-daily').textContent = daily;
                document.getElementById('popup-total').textContent = total;
                document.getElementById('popup-cycle').textContent = cycle + ' days';
                document.getElementById('popup-cycle-bottom').textContent = cycle;
                document.getElementById('popup-price').textContent = price;
                const p = parseFloat((price || '').toString().replace(/[^\d.]/g, '')) || 0,
                    t = parseFloat((total || '').toString().replace(/[^\d.]/g, '')) || 0;
                document.getElementById('popup-return').textContent = p > 0 ? Math.round(t / p * 100) + '% ROI' : '--';
                document.getElementById('popup-invest-btn').onclick = () => window.location.href = url;

                // close interactions
                window.addEventListener('keydown', escClose);
                popup.addEventListener('click', backdropClose);

                function escClose(e) {
                    if (e.key === 'Escape') closePopup();
                }

                function backdropClose(e) {
                    if (e.target === popup) closePopup();
                }
            }

            function closePopup() {
                const popup = document.getElementById('popup');
                popup.style.display = 'none';
                document.body.style.overflow = '';
                window.removeEventListener('keydown', () => {});
            }
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4c57108a433c26&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/plans.blade.php ENDPATH**/ ?>