<?php $__env->startSection('panel'); ?>

    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Limit'); ?></th>
                                <th><?php echo app('translator')->get('Type'); ?></th>
                                <th><?php echo app('translator')->get('Total Return'); ?></th>
                                <th><?php echo app('translator')->get('Interest Type'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Name'); ?>">
                                    <span class="font-weight-bold">
                                        <?php echo e(__($data->name)); ?>

                                    </span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Limit'); ?>">
                                    <span class="font-weight-bold" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Limitation of Amount'); ?>">
                                        <?php echo e($general->cur_sym); ?> <?php echo e(showAmount($data->min_amount)); ?> -
                                        <?php echo e($general->cur_sym); ?> <?php echo e(showAmount($data->max_amount)); ?>

                                    </span>
                                    </td>

                                    <td>
                                        <?php if($data->type == 1): ?>
                                            <?php echo app('translator')->get('Long Term plan'); ?>
                                        <?php elseif($data->type == 2): ?>
                                            <?php echo app('translator')->get('VIP plan'); ?>
                                        <?php endif; ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Total Return'); ?>">
                                        <?php echo e($data->total_return); ?> <?php echo app('translator')->get('Times'); ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Interest Type'); ?>">
                                        <?php if($data->interest_type == 0): ?>
                                            <?php echo app('translator')->get('Fixed'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('Percent'); ?>
                                        <?php endif; ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php if($data->status == 0): ?>
                                            <span class="badge badge--danger">
                                            <?php echo app('translator')->get('Disable'); ?>
                                        </span>
                                        <?php else: ?>
                                            <span class="badge badge--success">
                                            <?php echo app('translator')->get('Enable'); ?>
                                        </span>
                                        <?php endif; ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <a href="#0"

                                           data-id='<?php echo e($data->id); ?>'
                                           data-name='<?php echo e($data->name); ?>'
                                           data-status='<?php echo e($data->status); ?>'
                                           data-type='<?php echo e($data->type); ?>'
                                           data-min_amount='<?php echo e(getAmount($data->min_amount)); ?>'
                                           data-max_amount='<?php echo e(getAmount($data->max_amount)); ?>'
                                           data-total_return='<?php echo e($data->total_return); ?>'
                                           data-interest_type='<?php echo e($data->interest_type); ?>'
                                           data-interest='<?php echo e(getAmount($data->interest_amount)); ?>'
                                           data-buy_limit='<?php echo e($data->buy_limit); ?>'

                                           class="icon-btn editBtn"
                                           data-toggle="tooltip"
                                           title="<?php echo app('translator')->get('Edit'); ?>"
                                           data-original-title="<?php echo app('translator')->get('Edit'); ?>"
                                        >
                                            <i class="las la-edit text--shadow"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($plan)); ?>

                </div>
            </div>
        </div>

    </div>

    
    <div id="addModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add New Plan'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.plan.create')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="name"><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" name="name" class="form-control" id="name" required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="min_amount"><?php echo app('translator')->get('Minimum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="min_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="min_amount" class="form-control" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="max_amount"><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="max_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="max_amount" class="form-control" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="total_return"><?php echo app('translator')->get('How Many Return'); ?></label>
                                    <div class="input-group">
                                        <input type="number" id="total_return" value="4" class="form-control" name="total_return" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <?php echo app('translator')->get('Times'); ?>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="interest_type"><?php echo app('translator')->get('Interest Type'); ?></label>
                                    <div class="input-group">
                                        <select name="interest_type" id="interest_type" required class="form-control">
                                            <option><?php echo app('translator')->get('Select An Option'); ?></option>
                                            <option value="1" selected><?php echo app('translator')->get('Percent'); ?></option>
                                            <option value="0"><?php echo app('translator')->get('Fixed'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="interest"><?php echo app('translator')->get('Interest Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" value="10" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="interest" id="interest" class="form-control" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <span id="change_interest_symbol">%</span>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="status"><?php echo app('translator')->get('Status'); ?></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Enable'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('Disable'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="type"><?php echo app('translator')->get('Plan type'); ?></label>
                                    <select name="type" id="type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('LONG TERM PLAN'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('VIP PLAN'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="buy_limit"><?php echo app('translator')->get('Buy Limit'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="buy_limit" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="buy_limit" class="form-control" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Edit Plan'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.plan.edit')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <input type="hidden" name="id" required>

                    <div class="modal-body">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_name"><?php echo app('translator')->get('Name'); ?></label>
                                    <input type="text" name="name" class="form-control" id="edit_name" required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="edit_min_amount"><?php echo app('translator')->get('Minimum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="min_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_min_amount" class="form-control" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="edit_max_amount"><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="max_amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_max_amount" class="form-control" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_total_return"><?php echo app('translator')->get('How Many Return'); ?></label>
                                    <div class="input-group">
                                        <input type="number" id="edit_total_return" class="form-control" name="total_return" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <?php echo app('translator')->get('Times'); ?>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_interest_type"><?php echo app('translator')->get('Interest Type'); ?></label>
                                    <div class="input-group">
                                        <select name="interest_type" id="edit_interest_type" required class="form-control">
                                            <option><?php echo app('translator')->get('Select An Option'); ?></option>
                                            <option value="1"><?php echo app('translator')->get('Percent'); ?></option>
                                            <option value="0"><?php echo app('translator')->get('Fixed'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_interest"><?php echo app('translator')->get('Interest Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="interest" id="edit_interest" class="form-control" required>
                                        <div class="input-group-append">
                                        <span class="input-group-text">
                                            <span id="update_interest_symbol">%</span>
                                        </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_status"><?php echo app('translator')->get('Status'); ?></label>
                                    <select name="status" id="edit_status" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('Enable'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('Disable'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="edit_type"><?php echo app('translator')->get('Plan type'); ?></label>
                                    <select name="type" id="edit_type" class="form-control" required>
                                        <option value="1"><?php echo app('translator')->get('LONG TERM PLAN'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('VIP PLAN'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="edit_max_amount"><?php echo app('translator')->get('Buy Limit'); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="buy_limit" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" id="edit_max_amount" class="form-control" required>

                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Update'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="javascript:void(0)" class="btn btn-sm btn--primary box--shadow1 text-white text--small addBtn"><i class="fa fa-fw fa-plus"></i><?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {

            "use strict";

            $('.addBtn').on('click', (e)=> {
                var modal = $('#addModal');
                modal.modal('show');
            });

            $('#interest_type').on('change', (e)=>{
                var $this = e.currentTarget;

                var result = null;

                if($this.value == 0){
                    result = '<?php echo e(__($general->cur_text)); ?>';
                }else{
                    result = '%';
                }

                $('#change_interest_symbol').text(result);

            });

            $('#edit_interest_type').on('change', (e)=>{
                var $this = e.currentTarget;

                var result = null;

                if($this.value == 0){
                    result = '<?php echo e(__($general->cur_text)); ?>';
                }else{
                    result = '%';
                }

                $('#update_interest_symbol').text(result);

            });

            $('.editBtn').on('click', (e)=> {
                var $this = $(e.currentTarget);
                var modal = $('#editModal');

                var result = null;

                if($this.data('interest_type') == 0){
                    result = '<?php echo e(__($general->cur_text)); ?>';
                }else{
                    result = '%';
                }

                $('#update_interest_symbol').text(result);

                modal.find('input[name=id]').val($this.data('id'));
                modal.find('input[name=name]').val($this.data('name'));
                modal.find('input[name=total_return]').val($this.data('total_return'));
                modal.find('input[name=max_amount]').val($this.data('max_amount'));
                modal.find('input[name=min_amount]').val($this.data('min_amount'));
                modal.find('input[name=interest]').val($this.data('interest'));
                modal.find('select[name=status]').val($this.data('status'));
                modal.find('select[name=type]').val($this.data('type'));
                modal.find('select[name=interest_type]').val($this.data('interest_type'));
                modal.find('input[name=buy_limit]').val($this.data('buy_limit'));
                modal.modal('show');
            });

        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xsjpetiv/stellarretreat.com.ng/core/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>