<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="google" content="notranslate">
    <title><?php echo e($general->sitename); ?> - <?php echo $__env->yieldPushContent('page_title'); ?></title>

    <!-- Stylesheets -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/app/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/app/vendor/swiper/swiper-bundle.min.css')); ?>">

    <link href="https://fonts.googleapis.com/" rel="stylesheet">
    <link href="https://fonts.gstatic.com/" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@700&amp;display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/vant/lib/index.css" rel="stylesheet">



</head>


<body>

    <?php echo $__env->yieldContent('content'); ?>

</body>

<script src="<?php echo e(asset('assets/app/js/jquery.js')); ?>"></script>

<script src="<?php echo e(asset('assets/app/js/settings.js?v=7448')); ?>"></script>
<script src="<?php echo e(asset('assets/app/js/custom.js?v=45')); ?>"></script>
<script src="<?php echo e(asset('assets/app/js/dz.carousel.js')); ?>"></script><!-- Swiper -->
<script src="<?php echo e(asset('assets/app/vendor/swiper/swiper-bundle.min.js')); ?>"></script>

<script src="https://cdn.jsdelivr.net/npm/vant/lib/vant.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
    function showModal() {
        document.getElementById("newsModal").style.display = "flex";
    }

    function closeModal() {
        document.getElementById("newsModal").style.display = "none";
    }

    window.onload = showModal;

    window.onclick = function(event) {
        var modal = document.getElementById("newsModal");
        if (event.target == modal) {
            closeModal();
        }
    };


    function togglePopup() {
        var popup = document.getElementById("popup-box");
        popup.classList.toggle("show");
    }

    function openModal(data) {
        $("#product_price").html("Price : <?php echo e($general->cur_sym); ?> " + data.price);
        $("#product_days").html("Days: " + data.days);
        $("#product_name").html(data.name);
        $("#id").val(data.id);
        $("#product_description").html(data.description);
        $("#daily_income").html("<?php echo e($general->cur_sym); ?> " + data.daily_income);
        $("#total_income").html("<?php echo e($general->cur_sym); ?> " + (data.daily_income * data.days));
        $("#yesBtn").attr("onclick", "purchaseProduct('" + data.id + "')");
        $(".offcanvas").addClass("pwa-offcanvas show");
        $(".offcanvas").attr("style", "");
        $(".offcanvas-backdrop").addClass("show");
    }

    window.first = false;

    function navigate(path, complete = true) {
        history.go(-1);
    }
</script>

<script>
    function closePlan() {
        // Hide the offcanvas
        $(".offcanvas").removeClass("show");
        $(".offcanvas").attr("style", "display: none;");
        // Hide the backdrop
        $(".offcanvas-backdrop").removeClass("show");
    }
</script>


<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


</html>
<?php /**PATH /home/ildrhcvy/olamapp.com/core/resources/views/layouts/users.blade.php ENDPATH**/ ?>