<?php $__env->startSection('content'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <section class="opay_wrap">
        <header class="header_top main_Wrap bg-white mb-0">
            <div class="inner"> <a class="f-16" href="<?php echo e(URL::previous()); ?>"><i class="fa fa-angle-left"></i> Add/Update
                    Bank</a> </div>
        </header>
        <div class="opay_body payid_wrap bank_card_page mt-30">
            <div class="card">


                <div class="form_wrap">
                    <p class="f-14">Please carefully enter your payout bank account details below. Ensuring accuracy is
                        crucial to prevent any potential loss of funds. Double-check your bank account number, account name,
                        and other details for accuracy before submitting. Thank you for your attention to detail.</p>
                    <form class="form_box" method="post" action="">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="formGroupExampleInput" class="form-label f-14"><b>Bank</b></label>
                            <div class="form-wrap">
                                <select class="form-control pl-35" name="bank_code" id="bank_name" required>
                                    <option value="" selected>Select Bank</option>
                                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($bank['bank_code']); ?>"><?php echo e($bank['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select> <i class="fa fa-angle-right select_icon"></i> <i
                                    class="fa fa-bank select_bank"></i>
                            </div>
                        </div>
                        <div>
                            <div class="mb-3">
                                <label for="Bank-Account" class="form-label f-14"><b>Account Number</b></label>
                                <input type="number" placeholder="9631237890" value="" required class="form-control"
                                    name="account_number" id="account">
                            </div>

                            <span style="color:
                        red;" class="text-danger text-error block"></span>
                            <input type="hidden" name="bank_name" id="bank_code">

                            <div class="mb-3">
                                <label for="Bank-Account" class="form-label f-14"><b>Account Name</b></label>
                                <input type="text" class="form-control" name="account_name" id="account_name"
                                    placeholder="James Laka" value="" required readonly>
                            </div>
                        </div>

                        <button id="reg" disabled type="submit" class="theme_btn mt-30">Confirm</button>
                    </form>
                </div>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <textarea style="display: none;" id="all_banks"><?php echo $all_banks; ?></textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                //alert($(this).val());
                //let code = $("#bank_name").val(); //getByValue().bank_code;
                //let account = $("#account").val();

                //console.log(t, code);


                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                //console.log(code, account);

                let t = getByValue(code);

                //console.log(t);

                $("#bank_code").val(t);
                if (account != "" && code != "") {

                    get_account_info(code, account);

                    //console.log(account, code);
                }

            });

            $("#account").change(function() {

                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();
                if (account == "" || code == "") {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);

                //console.log(account, code);


            });





            function get_account_info(code, account) {

                $(".preloaders").show();
                $(".text-error").text("Fetching account details");

                $.ajax({
                    url: "<?php echo e(route('account.fetch')); ?>",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();
                            $(".text-error").text(
                                "Could not resolve account name, please check your account number or bank name and try again"
                            );
                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);

                        //console.log(response);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>

    <script>
        // Get the select element
        const bankSelect = document.getElementById('bank_name');
        // Get the input element
        const selectedBank = document.getElementById('bank_code');

        // Add event listener to the select element
        bankSelect.addEventListener('change', function() {
            // Get the selected option value
            const selectedOption = bankSelect.options[bankSelect.selectedIndex].text;
            // Update the value of the input field with the selected option value
            selectedBank.value = selectedOption;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/AMPPS/www/palmpay/core/resources/views/templates/basic/user/bank-setup.blade.php ENDPATH**/ ?>