<?php $__env->startPush('style'); ?>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
    <script>
        "use strict"

        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms * 1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " +
                    seconds + "s ";
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "COMPLETE";
                }
                tms--;
            }, 1000);
        }
    </script>

    <link href="<?php echo e(asset('css/order.css')); ?>" rel="stylesheet" type="text/css">

    <body class="orderListPage">
        <div class="app h5MaxWidth">
            <header>
                <div class="header h5MaxWidth clear display alignCenter">
                    <div class="back display alignCenter" onclick="history.back()">
                        <i class="iconfont icon-arrow-left"></i>
                    </div>
                    <h3 class="flex1">Order List</h3>
                    <div class="navskip" id="sideMenu"></div>
                </div>
            </header>
            <div class="main">
                <div class="myOrder" id="orderList">
                    <ul>
                        <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="commodityItem <?php echo e($plan->status == 0 ? 'state_1' : 'state_2'); ?>">
                                <div class="incomeDetails radius15PX">
                                    <ol class="cell">
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Plan</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p> <em class="unit"><?php echo e($plan->plan->name); ?></em></p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Payment amount</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><em class='currency'>₦</em><?php echo e(number_format($plan->amount, 2)); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Daily Income</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><em
                                                            class='currency'>₦</em><?php echo e(number_format($plan->interest_amount)); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Estimated Income</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><em
                                                            class='currency'>₦</em><?php echo e(number_format($plan->interest_amount * $plan->total_return, 2)); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </li>


                                        <li class="settle display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Status</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><?php echo e($plan->status == 0 ? 'Running..' : 'Completed'); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Working Days</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><?php echo e($plan->total_return); ?> <em class="unit">Day</em></p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Create Time</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><?php echo e($plan->created_at); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="display alignCenter">
                                            <div class="infoBar display alignCenter flex1">
                                                <div class="titleLabel flex1">
                                                    <p>Expire Time</p>
                                                </div>
                                                <div class="contInfo">
                                                    <p><?php echo e($plan->created_at->addDays($plan->total_return)); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                    </ol>
                                </div>
                            </li>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                            <div class="noData radius7PX">
                                <div class="tipIcon"><img src="<?php echo e(asset('img/01.png')); ?>" alt=""></div>
                                <h3>No records yet</h3>
                            </div>
                        <?php endif; ?>


                    </ul>
                </div>
            </div>
        </div>

        <?php echo $__env->make('templates.basic.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script type="text/javascript">
            var askData = {};
            var pageNum = 1;
            var tabLoadEndArray = false;

            $(document).ready(function() {
                $('#orderList').dropload({
                    scrollArea: window,
                    domDown: {
                        domClass: 'dropload-down',
                        domRefresh: '<div class="dropload-refresh">Pull up to load more</div>',
                        domLoad: '<div class="dropload-load display alignCenter justifyCenter"><i class="loading"></i><p></p></div>',
                        domNoData: '<div class="dropload-noData">No more data</div>'
                    },
                    loadDownFn: function(me) {
                        setTimeout(function() {
                            if (tabLoadEndArray) {
                                me.resetload();
                                me.lock();
                                me.noData();
                                me.resetload();
                                return;
                            }
                            orderList(me);
                        }, 500);
                    }
                });
            });

            // page	1	是	string	页码
            // size	2	是	string	条数
            // sortBy	1	是	string	0正序，1逆序
            // key		是	string	订单ID（不传查全部）

            function orderList(me) {

                askData = {
                    "page": pageNum,
                }

                _api.listOrder(askData, res => {
                    var orderHTML = '';
                    if (pageNum === 1 && isEmpty(res.data.datas)) {
                        orderHTML += '<div class="noData radius7PX">';
                        orderHTML += '<div class="tipIcon">';
                        orderHTML += '<img src="./../images/DefaultGraph/01.png" alt="" />';
                        orderHTML += '</div>';
                        orderHTML += '<h3>No records yet</h3>';
                        orderHTML += '</div>';
                        $("#orderList").html(orderHTML);
                        return;
                    } else if (res.data.datas.length > 0) {
                        $.each(res.data.datas, function(index, item) {
                            var stateClassName = isEmpty(item.status) ? "" : "state_" + item.status;
                            orderHTML += `
                                <li class="commodityItem ${stateClassName}"  onclick="jumpLink('./orderDetails.html?id=${item.id}',1)">
                                    <div class="incomeDetails radius15PX">
                                        <ol class="cell">
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Invest share</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${item.buy_share} <em class="unit">Copies</em></p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Payment amount</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p><em class='currency'>₦</em>${item.order_money_s}</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Daily Income</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p><em class='currency'>₦</em>${item.daily_income_s}</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Estimated Income</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p><em class='currency'>₦</em>${item.estimated_income_s}</p>
                                                    </div>
                                                </div>
                                            </li>
                            `;
                            if (item.product_type == 1 || item.product_type == 3) {
                                orderHTML += `
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Current Value</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p><em class='currency'>₦</em>${item.current_value_s}</p>
                                                    </div>
                                                </div>
                                            </li>
                                `;
                            } else {
                                orderHTML += `
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Generated Money</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p><em class='currency'>₦</em>${item.generated_money_s}</p>
                                                    </div>
                                                </div>
                                            </li>
                                `;
                            }
                            orderHTML += `
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Goods type</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${productType(item.product_type).label}</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="settle display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Status</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${settleStatus(item.status).label}</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Working Days</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${item.working_days} <em class="unit">Day</em></p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Create Time</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${item.create_time}</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="display alignCenter">
                                                <div class="infoBar display alignCenter flex1">
                                                    <div class="titleLabel flex1">
                                                        <p>Expire Time</p>
                                                    </div>
                                                    <div class="contInfo">
                                                        <p>${item.expire_time}</p>
                                                    </div>
                                                </div>
                                            </li>
                                        </ol>
                                    </div>
                                </li>
                            `;
                        });
                        $("#orderList>ul").append(orderHTML);
                        pageNum = pageNum + 1
                        me.resetload();
                    } else {
                        tabLoadEndArray = true;
                        me.resetload();
                    }
                });
            }
        </script>


    </body>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/AMPPS/www/olam/core/resources/views/templates/basic/user/investment_log.blade.php ENDPATH**/ ?>