<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --ink: #3b2613;
            /* main text */
            --muted: #7a6a58;
            /* secondary */
            --line: rgba(0, 0, 0, .08);
            --page1: #f7f2e9;
            /* paper base */
            --page2: #f0e6d9;
            /* warm blend */
            --card: #fffaf2;
            /* card */
            --shadow: 0 12px 28px rgba(184, 115, 51, .18);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0
        }

        html,
        body {
            height: 100%
        }

        body {
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                linear-gradient(180deg, var(--page1), var(--page2) 60%, var(--page1));
            display: flex;
            justify-content: center;
            padding: 16px;
        }

        .container {
            width: 100%;
            max-width: 540px;
            min-height: 100dvh;
        }

        /* Header */
        .top {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 0 12px;
        }

        .back {
            width: 38px;
            height: 38px;
            display: grid;
            place-items: center;
            border-radius: 12px;
            border: 1px solid var(--line);
            background: linear-gradient(180deg, #ffffff, #fff4e7);
            color: var(--accent);
            text-decoration: none;
            box-shadow: 0 6px 18px rgba(184, 115, 51, .15);
        }

        .ico {
            width: 18px;
            height: 18px
        }

        .title {
            flex: 1;
            text-align: center;
            font-size: 18px;
            font-weight: 900;
            letter-spacing: .2px;
            color: var(--accent);
            text-shadow: 0 0 10px rgba(184, 115, 51, .22);
        }

        /* Wallet label */
        .wallet-row {
            margin: 12px 0 18px;
            padding: 0 2px;
            color: var(--muted);
            font-weight: 700;
            font-size: 14px;
            letter-spacing: .2px;
        }

        .wallet-row .name {
            color: var(--accent);
            font-weight: 900;
            margin-left: 6px;
        }

        /* Input fields */
        .label {
            margin: 8px 2px -6px;
            font-weight: 800;
            color: var(--muted);
            font-size: 14px;
        }

        .field {
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1px solid var(--line);
            border-radius: 16px;
            padding: 12px 14px;
            margin: 14px 0;
            box-shadow: 0 6px 18px rgba(184, 115, 51, .12);
            transition: border .2s ease, box-shadow .2s ease;
        }

        .field:focus-within {
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(214, 162, 94, .25);
        }

        .field input,
        .field select {
            width: 100%;
            border: 0;
            outline: none;
            background: transparent;
            color: var(--ink);
            font-size: 16px;
            font-weight: 600;
        }

        /* Save button */
        .primary {
            width: 100%;
            height: 50px;
            border: 0;
            cursor: pointer;
            margin-top: 20px;
            border-radius: 16px;
            color: white;
            font-weight: 900;
            font-size: 16px;
            letter-spacing: .2px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            box-shadow: 0 12px 28px rgba(184, 115, 51, .30);
            transition: transform .15s ease, box-shadow .15s ease, filter .2s ease;
        }

        .primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 14px 32px rgba(184, 115, 51, .36);
            filter: brightness(1.03);
        }

        /* Helper text */
        .helper {
            margin-top: 12px;
            font-size: 12px;
            color: var(--muted);
            text-align: center;
            font-weight: 600;
        }
    </style>

    <body>
        <div class="container">

            <!-- Header -->
            <div class="top">
                <a href="javascript:history.back()" class="back" aria-label="Back">
                    <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M15.5 5l-7 7 7 7"></path>
                    </svg>
                </a>
                <div class="title">Add Bank Account</div>
                <span style="width:38px;"></span>
            </div>

            <!-- Wallet label -->
            

            <!-- Form -->
            <form action="" method="POST" autocomplete="off">
                <input type="hidden" name="_token" value="s9eY2Rcak6KBaxuXWVIVrqafvmEs6Zv4ooWvN4yM">
                <div class="label">Account Number</div>
                <div class="field">
                    <input type="text" name="account_number" id="account" placeholder="Enter your account number"
                        required="">
                </div>

                <div class="label">Account Name</div>
                <div class="field">
                    <input type="text" name="account_name" id="account_name" placeholder="Enter account name"
                        required="">
                </div>

                <div class="label">Account Type</div>
                <div class="field">
                    <select name="bank_code" id="gatewayMethod" required="">
                        <option value="" disabled="">Select</option>
                        <option value="gcash" selected="">GCash</option>
                        <option value="PMP">Paymaya</option>
                    </select>
                </div>

                <input type="hidden" name="bank_name" id="bank_code">

                <button type="submit" class="primary">Save</button>
            </form>

            <div class="helper">Please ensure your account details match your wallet provider.</div>
        </div>

        <script>
            // Sync selected wallet name
            const sel = document.getElementById('gatewayMethod');
            const nameEl = document.getElementById('walletName');
            if (sel && nameEl) {
                const sync = () => {
                    nameEl.textContent = sel.value || nameEl.textContent;
                };
                sel.addEventListener('change', sync);
                sync();
            }
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4a8a51b9c9c118&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <textarea style="display: none;" id="all_banks"><?php echo $all_banks; ?></textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                //alert($(this).val());
                //let code = $("#bank_name").val(); //getByValue().bank_code;
                //let account = $("#account").val();

                //console.log(t, code);


                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                //console.log(code, account);

                let t = getByValue(code);

                //console.log(t);

                $("#bank_code").val(t);
                if (account != "" && code != "") {

                    get_account_info(code, account);

                    //console.log(account, code);
                }

            });

            $("#account").change(function() {

                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();
                if (account == "" || code == "") {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);

                //console.log(account, code);


            });





            function get_account_info(code, account) {

                $(".preloaders").show();

                $.ajax({
                    url: "<?php echo e(route('account.fetch')); ?>",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();

                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);

                        //console.log(response);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>

    <script>
        // Get the select element
        const bankSelect = document.getElementById('bank_name');
        // Get the input element
        const selectedBank = document.getElementById('bank_code');

        // Add event listener to the select element
        bankSelect.addEventListener('change', function() {
            // Get the selected option value
            const selectedOption = bankSelect.options[bankSelect.selectedIndex].text;
            // Update the value of the input field with the selected option value
            selectedBank.value = selectedOption;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/bank-setup.blade.php ENDPATH**/ ?>