<?php $__env->startSection('content'); ?>
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --page: #f7f2e9;
            --panel: #fffaf2;
            --ink: #3b2613;
            --muted: #7a6a58;
            --line: rgba(0, 0, 0, .08);
            --accent1: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte  */
            --shadow: 0 12px 28px rgba(184, 115, 51, .20);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--page);
            padding-bottom: 100px;
        }

        /* TOP BAR */
        .top-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 14px 16px;
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--line);
            position: sticky;
            top: 0;
            z-index: 60;
            font-weight: 900;
            letter-spacing: .3px;
            color: var(--accent1);
            box-shadow: 0 2px 8px rgba(184, 115, 51, .16);
        }

        .top-bar .back {
            text-decoration: none;
            color: var(--muted);
            font-weight: 800;
            font-size: 15px
        }

        .top-bar .back:hover {
            color: var(--accent1)
        }

        .top-bar .right a {
            text-decoration: none;
            color: var(--accent1);
            font-weight: 800;
            border: 1px solid var(--line);
            border-radius: 10px;
            padding: 6px 12px;
            background: #fff6e8;
            transition: .25s;
        }

        .top-bar .right a:hover {
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            border-color: transparent;
        }

        /* HEADER */
        .header {
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            padding: 30px 18px;
            text-align: center;
            font-weight: 900;
            border-bottom-left-radius: 26px;
            border-bottom-right-radius: 26px;
            box-shadow: 0 16px 30px rgba(184, 115, 51, .25);
        }

        .balance {
            font-size: 30px;
            font-weight: 900;
            margin-top: 4px
        }

        .sub {
            font-size: 14px;
            opacity: .9;
            font-weight: 700
        }

        /* WRAP */
        .wrap {
            padding: 18px 16px
        }

        /* CARD */
        .card {
            background: linear-gradient(180deg, #ffffff, #fff4e7);
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 18px;
            box-shadow: var(--shadow);
        }

        .title {
            font-weight: 900;
            font-size: 15px;
            margin-bottom: 10px;
            color: var(--accent1);
        }

        /* INPUT */
        .field {
            display: flex;
            align-items: center;
            gap: 10px;
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 12px 14px;
            margin: 10px 0;
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            transition: all .25s;
        }

        .field:focus-within {
            border-color: var(--accent1);
            box-shadow: 0 0 10px rgba(184, 115, 51, .18);
        }

        .field input {
            flex: 1;
            border: 0;
            outline: none;
            background: transparent;
            color: var(--ink);
            font-size: 16px;
        }

        /* CHIPS */
        .chips {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px
        }

        .chip {
            border: 1px solid var(--line);
            background: #fff6e8;
            border-radius: 999px;
            padding: 8px 16px;
            font-weight: 800;
            color: var(--ink);
            cursor: pointer;
            transition: .25s;
        }

        .chip.active,
        .chip:hover {
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            border-color: transparent;
            box-shadow: 0 8px 20px rgba(184, 115, 51, .28);
        }

        /* ACCOUNT */
        .acct {
            background: #fff8ee;
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 12px;
            color: var(--muted);
            font-weight: 800;
            margin-top: 10px;
        }

        /* CALC */
        .calc {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-top: 14px;
        }

        .calc .box {
            background: #fffaf2;
            border: 1px solid var(--line);
            border-radius: 14px;
            text-align: center;
            padding: 12px;
            box-shadow: var(--shadow);
        }

        .calc .k {
            font-size: 13px;
            color: var(--muted)
        }

        .calc .v {
            font-size: 16px;
            font-weight: 900;
            margin-top: 4px;
            color: var(--accent1)
        }

        /* BUTTON */
        .btn {
            width: 100%;
            border: 0;
            border-radius: 14px;
            padding: 14px 16px;
            margin-top: 16px;
            font-weight: 900;
            font-size: 16px;
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            cursor: pointer;
            box-shadow: 0 16px 30px rgba(184, 115, 51, .25);
            transition: .25s;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 18px 36px rgba(184, 115, 51, .32)
        }

        .btn:disabled {
            opacity: .6;
            cursor: not-allowed
        }

        /* TIPS */
        .tips {
            margin-top: 18px;
            font-size: 13px;
            color: var(--muted);
            background: #fff8ee;
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 14px;
            line-height: 1.6;
            box-shadow: var(--shadow);
        }

        .tips .highlight {
            color: var(--accent1);
            font-weight: 900
        }

        /* TOAST */
        .toast {
            position: fixed;
            left: 50%;
            bottom: 90px;
            transform: translateX(-50%);
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            padding: 10px 16px;
            border-radius: 999px;
            font-weight: 900;
            display: none;
            box-shadow: 0 10px 30px rgba(184, 115, 51, .30);
            z-index: 9999;
        }
    </style>

    <body>

        <div class="top-bar">
            <a class="back" href="#" onclick="window.location.href='<?php echo e(route('user.profile.setting')); ?>'">← Back</a>
            <div>Withdraw</div>
            <div class="right"><a href="#"
                    onclick="window.location.href='<?php echo e(route('user.withdraw.history')); ?>'">History</a></div>
        </div>

        <header class="header">
            <div class="balance"><?php echo e($general->cur_sym); ?><?php echo e(number_format(auth()->user()->bonus_balance, 2)); ?></div>
            <div class="sub">Current Balance</div>
        </header>

        <main class="wrap">
            <form id="withdrawForm" class="card" method="POST" novalidate="">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="withdrawBalance" name="balance" value="2">
                <input type="hidden" id="withdrawMethodCode" name="method_code" value="1">
                <div class="title">Withdraw amount</div>
                <label class="field">
                    <span style="font-weight:900;color:var(--accent1)"><?php echo e($general->cur_sym); ?></span>
                    <input id="amount" name="amount" type="number"
                        min="<?php echo e(number_format($withdrawMainMethod->min_limit)); ?>" oninput="recalc()" required=""
                        placeholder="Enter amount (min <?php echo e($general->cur_sym); ?><?php echo e(number_format($withdrawMainMethod->min_limit)); ?>)">
                </label>
                <div class="chips">
                    <button type="button" class="chip" onclick="setAmount(Math.floor(balance))">Max</button>
                </div>

                <div class="title" style="margin-top:14px">Withdraw account</div>
                <div class="acct">Account: <?php echo e(Split_Hide_Name(auth()->user()->bankAccount->account_number)); ?></div>

                <div class="calc">
                    <div class="box">
                        <div class="k">Fee (<?php echo e(round($withdrawMainMethod->percent_charge)); ?>%)</div>
                        <div class="v"><?php echo e($general->cur_sym); ?><span id="fee">0.00</span></div>
                    </div>
                    <div class="box">
                        <div class="k">Actual Received</div>
                        <div class="v"><?php echo e($general->cur_sym); ?><span id="actual">0.00</span></div>
                    </div>
                </div>

                <button type="submit" class="btn" id="submitBtn" onclick="submitWithdraw()">Withdraw now</button>
            </form>

            <section class="tips">
                <div><b>1.</b> Minimum withdrawal: <span
                        class="highlight"><?php echo e($general->cur_sym); ?><?php echo e(number_format($withdrawMainMethod->min_limit)); ?></span>.
                    You must purchase a plan before
                    withdrawal.</div>
                <div><b>2.</b> Application time: <span class="highlight">24/7</span></div>
                <div><b>3.</b> Unlimited withdrawals per day.</div>
                <div><b>4.</b> Arrival time: <span class="highlight">30 minutes – 3 hours</span>.</div>
                <div><b>5.</b> Fee: <span class="highlight"><?php echo e(round($withdrawMainMethod->percent_charge)); ?>%</span></div>
            </section>
        </main>

        <div class="toast" id="toast">Message</div>

        <script>
            const feeRate = '<?php echo e(round($withdrawMainMethod->percent_charge)); ?>';
            const minAmt = '<?php echo e($withdrawMainMethod->min_limit); ?>';
            const balance = '<?php echo e(auth()->user()->bonus_balance); ?>';
            const hasAcct = true;

            const amountEl = document.getElementById('amount');
            const feeEl = document.getElementById('fee');
            const actualEl = document.getElementById('actual');
            const submitBtn = document.getElementById('submitBtn');
            const toast = document.getElementById('toast');

            function showToast(msg) {
                toast.textContent = msg;
                toast.style.display = 'block';
                setTimeout(() => toast.style.display = 'none', 1800);
            }

            function format(n) {
                return (isFinite(n) ? n : 0).toFixed(2);
            }

            function recalc() {
                const amt = parseFloat(amountEl.value || '0');
                const fee = amt * (feeRate / 100);
                const actual = Math.max(0, amt - fee);
                feeEl.textContent = format(fee);
                actualEl.textContent = format(actual);
                submitBtn.disabled = !(amt >= minAmt && amt <= balance && hasAcct);
            }

            function setAmount(v) {
                amountEl.value = Math.floor(v);
                document.querySelectorAll('.chip').forEach(c => c.classList.remove('active'));
                recalc();
            }
            document.getElementById('withdrawForm').addEventListener('submit', e => {
                const amt = parseFloat(amountEl.value || '0');
                if (!hasAcct) {
                    e.preventDefault();
                    showToast('Please bind an account first.');
                    return;
                }
                if (isNaN(amt) || amt < minAmt) {
                    e.preventDefault();
                    showToast('Minimum <?php echo e($general->cur_sym); ?>' + minAmt);
                    return;
                }
                if (amt > balance) {
                    e.preventDefault();
                    showToast('Amount exceeds balance.');
                    return;
                }
                submitBtn.disabled = true;
            });
            recalc();
        </script>

        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4a9728c96b7a3e&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>


    <script>
        function submitWithdraw() {
            const button = $("#submitBtn");
            button.prop("disabled", true);

            const methodCode = $("#withdrawMethodCode").val();
            const amount = $("#amount").val();
            const balance = $("#withdrawBalance").val();



            $.ajax({
                url: "<?php echo e(route('user.withdraw.money')); ?>",
                method: "POST",
                data: {
                    method_code: methodCode,
                    amount: amount,
                    balance: balance,
                    _token: $('meta[name="csrf-token"]').attr("content")
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        window.location.href = "<?php echo e(route('user.withdraw')); ?>";
                    } else {
                        alert(response.error);
                        if (response.redirect_url) {
                            window.location.href = response.redirect_url;
                        }
                        button.prop("disabled", false);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation error from the controller
                        alert(xhr.responseJSON.error);
                    } else {
                        // General error

                        alert(xhr.responseJSON.error);
                        if (xhr.responseJSON.redirect_url) {
                            window.location.href = xhr.responseJSON.redirect_url;
                        }
                    }
                    button.prop("disabled", false);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/coffe/core/resources/views/templates/basic/user/withdraw/methods.blade.php ENDPATH**/ ?>