<?php $__env->startPush('style'); ?>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
    <script>
        "use strict"

        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms * 1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " +
                    seconds + "s ";
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "COMPLETE";
                }
                tms--;
            }, 1000);
        }
    </script>

    <link rel="stylesheet" href="<?php echo e(asset('assets/InvestList-ElEMLdhA.css')); ?>">

    <body>
        <div id="app" data-v-app="">
            <div class="orderListPage bg_00">
                <div>
                    <div class="van-sticky">
                        <div class="van-nav-bar van-hairline--bottom">
                            <div class="van-nav-bar__content">
                                <div onclick="window.history.go(-1); return false;" class="van-nav-bar__left van-haptics-feedback"><i
                                        class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow"><!----><!----><!----></i>
                                </div>
                                <div class="van-nav-bar__title van-ellipsis">My orders</div><!---->
                            </div>
                        </div>
                    </div>
                </div>
                <div class="main">
                    <div class="orderList">
                        <div role="feed" class="van-list" aria-busy="false"><!---->
                            <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div data-v-f53d3b17=""
                                    class="recordTopUp perRecord m5 p10 <?php echo e($plan->status == 1 ? 'status_2' : 'status_1'); ?>">
                                    <ul data-v-f53d3b17="" class="cell">
                                        <li data-v-f53d3b17="" class="display alignStretch justifyDetween">
                                            <div data-v-f53d3b17="" class="titleLabel"><span data-v-f53d3b17="">Price
                                                    money</span></div>
                                            <div data-v-f53d3b17="" class="contInfo flex1 tr">
                                                <h4 data-v-f53d3b17=""><em data-v-f53d3b17=""
                                                        class="currency">₦</em><?php echo e(number_format($plan->amount, 2)); ?>

                                                </h4>
                                            </div>
                                        </li>
                                        <li data-v-f53d3b17="" class="display alignStart justifyDetween">
                                            <div data-v-f53d3b17="" class="titleLabel"><span data-v-f53d3b17="">Daily
                                                    Income</span></div>
                                            <div data-v-f53d3b17="" class="contInfo flex1 tr">
                                                <p data-v-f53d3b17=""><?php echo e(number_format($plan->interest_amount)); ?></p>
                                            </div>
                                        </li>
                                        <li data-v-f53d3b17="" class="resultStatus display alignStart justifyDetween">
                                            <div data-v-f53d3b17="" class="titleLabel"><span data-v-f53d3b17="">Total
                                                    Revenue:</span>
                                            </div>
                                            <div data-v-f53d3b17="" class="contInfo flex1 tr">
                                                <p data-v-f53d3b17="">
                                                    <?php echo e(number_format($plan->interest_amount * $plan->total_return)); ?>

                                                </p>
                                            </div>
                                        </li>
                                        <li data-v-f53d3b17="" class="resultStatus display alignStart justifyDetween">
                                            <div data-v-f53d3b17="" class="titleLabel"><span data-v-f53d3b17="">Total
                                                    Paid:</span>
                                            </div>
                                            <div data-v-f53d3b17="" class="contInfo flex1 tr">
                                                <p data-v-f53d3b17="">
                                                    <?php echo e(number_format($plan->total_paid * $plan->interest_amount, 2)); ?>

                                                </p>
                                            </div>
                                        </li>
                                        <?php
                                            $nextTime = \Carbon\Carbon::parse($plan->next_return_date);
                                        ?>

                                        <script>
                                            createCountDown('counter<?php echo e($plan->id); ?>', <?php echo e($nextTime->diffInSeconds()); ?>);
                                        </script>

                                        <h5 class="info-title">Next Date: <span class="info-value" id="counter<?php echo e($plan->id); ?>"></span></h5>


                                    </ul>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="van-list__finished-text">No more.</div><!---->
                            <div class="van-list__placeholder"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </body>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/cryptoworld/core/resources/views/templates/basic/user/investment_log.blade.php ENDPATH**/ ?>