<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Lucky Spin</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      padding-top: 40px;
    }
    .wheel-container {
      position: relative;
      width: 300px;
      margin: auto;
    }
    .wheel {
      width: 300px;
      height: 300px;
      border-radius: 50%;
      border: 10px solid #0fd9d9;
      position: relative;
      transform: rotate(0deg);
      transition: transform 4s cubic-bezier(0.33, 1, 0.68, 1);
    }
    .slice {
      --total: 8;
      position: absolute;
      width: 50%;
      height: 50%;
      background: #fdd835;
      transform-origin: 100% 100%;
      transform: rotate(calc(360deg / var(--total) * var(--i))) skewY(-45deg);
      display: flex;
      align-items: center;
      justify-content: flex-end;
      padding-right: 10px;
      font-weight: bold;
      color: #000;
    }
    .pointer {
      width: 0;
      height: 0;
      border-left: 15px solid transparent;
      border-right: 15px solid transparent;
      border-bottom: 30px solid orange;
      position: absolute;
      top: -20px;
      left: 50%;
      transform: translateX(-50%);
    }
    button {
      margin-top: 20px;
      padding: 10px 20px;
      font-weight: bold;
      cursor: pointer;
    }
    .info {
      margin-top: 20px;
    }
  </style>
</head>
<body>

<h2>Lucky Spin</h2>
<div class="wheel-container">
  <div class="wheel" id="wheel">
    <div class="slice" style="--i:0;">20,000 ETB</div>
    <div class="slice" style="--i:1;">50 ETB</div>
    <div class="slice" style="--i:2;">100 ETB</div>
    <div class="slice" style="--i:3;">200 ETB</div>
    <div class="slice" style="--i:4;">500 ETB</div>
    <div class="slice" style="--i:5;">2000 ETB</div>
    <div class="slice" style="--i:6;">5000 ETB</div>
    <div class="slice" style="--i:7;">10,000 ETB</div>
  </div>
  <div class="pointer"></div>
  <button onclick="spin()">GO SPIN</button>
</div>

<div class="info">
  <p><strong>Deposit Wallet:</strong> <span id="wallet">0</span> ETB</p>
  <p><strong>Chance:</strong> <span id="chances">0</span></p>
  <button onclick="earnChance()">+100 ETB to Earn Chance</button>
</div>

<script>
  let angle = 0;
  let wallet = 1000;  // Initial ETB for testing
  let chances = 0;

  function updateDisplay() {
    document.getElementById('wallet').textContent = wallet;
    document.getElementById('chances').textContent = chances;
  }

  function spin() {
    if (chances <= 0) {
      alert("No chances left. Earn or buy more!");
      return;
    }

    chances--;
    const spins = Math.floor(Math.random() * 8);
    const rotateBy = 360 * 5 + spins * 45;
    angle += rotateBy;

    document.getElementById('wheel').style.transform = `rotate(${angle}deg)`;

    setTimeout(() => {
      const rewards = [20000, 50, 100, 200, 500, 2000, 5000, 10000];
      wallet += rewards[spins];
      updateDisplay();
      alert(`You won ${rewards[spins]} ETB!`);
    }, 4000);
  }

  function earnChance(amount = 100) {
    if (wallet >= amount) {
      wallet -= amount;
      chances++;
      updateDisplay();
    } else {
      alert("Not enough ETB to earn a chance.");
    }
  }

  updateDisplay();
</script>

</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/olex/core/resources/views/templates/basic/user/spin.blade.php ENDPATH**/ ?>