@extends('layouts.users')


@section('content')
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --ink: #3b2613;
            /* main text */
            --muted: #7a6a58;
            /* secondary text */
            --page1: #f7f2e9;
            /* paper base */
            --page2: #efe4d6;
            /* warm blend */
            --card: #fffaf2;
            /* card */
            --line: rgba(0, 0, 0, .08);
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --danger: #cc3e3e;
            /* reject red */
            --pending: #d59d2b;
            /* yellow */
            --success: #1a9a73;
            /* green */
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
            --shadow-soft: 0 6px 20px rgba(184, 115, 51, .18);
            --shadow-hover: 0 10px 28px rgba(184, 115, 51, .28);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(900px 600px at 50% 8%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                linear-gradient(180deg, var(--page1), var(--page2) 80%, var(--page1));
        }

        /* Container */
        .app {
            max-width: 540px;
            margin: 0 auto;
            padding: 16px;
            padding-bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .title {
            font-size: 22px;
            font-weight: 900;
            text-align: center;
            color: var(--accent);
            letter-spacing: .3px;
            margin: 12px 0 18px;
            text-shadow: 0 0 10px rgba(184, 115, 51, .22);
        }

        /* List layout */
        .list {
            display: flex;
            flex-direction: column;
            gap: 14px
        }

        .card {
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1px solid var(--line);
            border-radius: 18px;
            box-shadow: var(--shadow-soft);
            padding: 14px;
            transition: transform .2s ease, box-shadow .2s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-hover);
        }

        .row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px 2px;
        }

        .row+.row {
            border-top: 1px solid var(--line)
        }

        .k {
            color: var(--muted);
            font-weight: 700;
            font-size: 13px
        }

        .v {
            font-weight: 900;
            font-size: 14px
        }

        .v.date {
            color: var(--accent)
        }

        .v.amount {
            color: var(--accent);
            display: flex;
            gap: 6px;
            align-items: baseline;
            font-size: 16px
        }

        .peso {
            font-size: .85em;
            opacity: .8;
            font-weight: 800
        }

        .status {
            font-weight: 900
        }

        .status.success {
            color: var(--success)
        }

        .status.pending {
            color: var(--pending)
        }

        .status.rejected {
            color: var(--danger)
        }

        /* Empty State */
        .empty {
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            border: 1px dashed var(--line);
            color: var(--muted);
            padding: 28px 14px;
            border-radius: 16px;
            text-align: center;
            font-weight: 700;
            letter-spacing: .2px;
            box-shadow: 0 6px 20px rgba(184, 115, 51, .14);
        }

        /* Tab Bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
            box-shadow: 0 -4px 16px rgba(184, 115, 51, .20);
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            transition: color .2s ease;
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent)
        }

        .tab.active .ico {
            color: var(--accent)
        }

        .tab:hover {
            color: var(--accent2)
        }
    </style>

    <body>

        <div class="app">
            <div class="title">Withdrawal Records</div>

            <div class="list">

                @forelse ($withdraws as $k => $data)
                    <article class="card">
                        <div class="row">
                            <div class="k">Withdraw Date</div>
                            <div class="v date">{{ $data->created_at }}</div>
                        </div>

                        <!-- Order ID Row -->
                        <div class="row">
                            <div class="k">Order ID</div>
                            <div class="v">{{ $data->trx }}</div>
                        </div>

                        <div class="row">
                            <div class="k">Money</div>
                            <div class="v amount"><span
                                    class="peso">({{ $general->cur_sym }})</span>{{ number_format($data->amount) }}</div>
                        </div>
                        <div class="row">
                            <div class="k">Status</div>

                            @if ($data->status == 1)
                                <div class="status success">Success</div>
                            @elseif ($data->status == 2)
                                <div class="status pending">Processing</div>
                            @else
                                <div class="status danger">Failed</div>
                            @endif
                        </div>
                    </article>


                @empty
                    <div class="empty">No withdraw records found.</div>
                @endforelse
            </div>
        </div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')

        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4c518cb86adc35&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
@endsection
