@extends('layouts.users')


@section('content')
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --caramel: #b87333;
            /* primary accent */
            --latte: #d6a25e;
            /* secondary accent */
            --ink: #3b2613;
            /* main text */
            --muted: #7a6a58;
            /* secondary text */
            --page: #f7f2e9;
            /* paper base */
            --page2: #efe4d6;
            /* warm blend */
            --card: #fffaf2;
            /* card paper */
            --chip: #f8f1e6;
            /* soft chip */
            --line: rgba(0, 0, 0, .08);
            --shadow: 0 10px 28px rgba(184, 115, 51, .18);
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(900px 600px at 55% 8%, rgba(255, 255, 255, .7), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat fixed,
                linear-gradient(var(--page), var(--page2) 60%, var(--page));
            display: flex;
            justify-content: center;
        }

        .app {
            width: 100%;
            max-width: 540px;
            padding: 16px 14px calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .title {
            font-weight: 900;
            font-size: 22px;
            letter-spacing: .3px;
            margin: 16px 2px 12px;
            color: var(--caramel);
            text-shadow: 0 0 10px rgba(184, 115, 51, .22);
        }

        .tile {
            display: flex;
            align-items: center;
            gap: 12px;
            background: linear-gradient(180deg, #ffffff, var(--card));
            border: 1px solid var(--line);
            border-radius: 16px;
            padding: 14px;
            margin-bottom: 12px;
            box-shadow: var(--shadow);
        }

        .tile .icon {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            display: grid;
            place-items: center;
            background: linear-gradient(180deg, #fff7ec, var(--chip));
            border: 1px solid var(--line);
            color: var(--caramel);
        }

        .tile .main {
            flex: 1
        }

        .tile .k {
            font-size: 12px;
            color: var(--muted)
        }

        .tile .v {
            font-weight: 800;
            word-break: break-all;
            color: var(--ink)
        }

        .copy {
            border: 1px solid transparent;
            color: #fff;
            background: linear-gradient(90deg, var(--caramel), var(--latte));
            padding: 8px 12px;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 800;
            font-size: 13px;
            box-shadow: 0 4px 14px rgba(184, 115, 51, .25);
            transition: .2s;
        }

        .copy:hover {
            filter: brightness(1.05);
            transform: translateY(-1px)
        }

        .summary {
            background: linear-gradient(180deg, #ffffff, var(--card));
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 14px;
            margin: 14px 0 8px;
            box-shadow: var(--shadow);
        }

        .summary .label {
            font-size: 12px;
            color: var(--muted);
        }

        .summary .value {
            font-size: 22px;
            font-weight: 900;
            color: var(--caramel);
        }

        .grid {
            display: flex;
            gap: 12px;
            margin-top: 10px
        }

        .grid .box {
            flex: 1;
            background: var(--chip);
            border: 1px solid var(--line);
            border-radius: 12px;
            padding: 10px;
            text-align: center;
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, .04);
        }

        .grid .box b {
            display: block;
            color: var(--caramel);
            margin-top: 3px
        }

        .level {
            background: linear-gradient(180deg, #ffffff, var(--card));
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 14px;
            margin: 10px 0;
            box-shadow: var(--shadow);
        }

        .level .head {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            margin-bottom: 8px;
        }

        .level .name {
            font-weight: 900;
            color: var(--ink)
        }

        .pill {
            background: rgba(214, 162, 94, .14);
            color: var(--caramel);
            border: 1px solid rgba(214, 162, 94, .35);
            padding: 6px 10px;
            border-radius: 999px;
            font-weight: 800;
            font-size: 12px;
        }

        .meta {
            display: flex;
            gap: 12px;
        }

        .meta .col {
            flex: 1;
            background: var(--chip);
            border: 1px solid var(--line);
            border-radius: 12px;
            padding: 10px;
            text-align: center;
        }

        .meta .col b {
            display: block;
            color: var(--caramel);
            margin-top: 2px
        }

        .view {
            margin-top: 10px;
            width: 100%;
            border: none;
            background: linear-gradient(90deg, var(--caramel), var(--latte));
            color: #fff;
            padding: 10px 12px;
            border-radius: 12px;
            font-weight: 800;
            cursor: pointer;
            box-shadow: 0 6px 16px rgba(184, 115, 51, .25);
            transition: .2s;
        }

        .view:hover {
            transform: translateY(-1px);
            filter: brightness(1.05)
        }

        .toast {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 14px);
            background: linear-gradient(90deg, var(--caramel), var(--latte));
            color: white;
            padding: 10px 14px;
            border-radius: 12px;
            display: none;
            box-shadow: 0 10px 24px rgba(184, 115, 51, .25);
            z-index: 50;
            font-weight: 800;
        }

        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            min-height: var(--tabbar-h);
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(6px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
            box-shadow: 0 -4px 16px rgba(184, 115, 51, .20);
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
            padding: 10px 0;
            transition: color .2s ease;
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--caramel)
        }

        .tab.active .ico {
            color: var(--caramel)
        }

        .tab:hover {
            color: var(--latte)
        }
    </style>

    <body>
        <div class="app">
            <div class="title">My Team</div>

            <!-- INVITE LINK -->
            <div class="tile">
                <div class="icon">
                    <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                        <path
                            d="M10 13a5 5 0 010-7l2-2a5 5 0 017 7l-1 1-1.41-1.41 1-1a3 3 0 10-4.24-4.24l-2 2a3 3 0 104.24 4.24L16 9l1.41 1.41-1 1A5 5 0 0110 13zM4 20a5 5 0 01-3.54-8.54l1-1L2.87 12l-1 1A3 3 0 006.1 17.2l2-2A3 3 0 107.88 10L9.3 8.59A5 5 0 0116.3 15.6l-2 2A5 5 0 014 20z">
                        </path>
                    </svg>
                </div>
                <div class="main">
                    <div class="k">Invitation link</div>
                    <div class="v" id="link">{{ route('home') }}?shareCode={{ auth()->user()->ref_code }}</div>
                </div>
                <button class="copy" onclick="copyText('#link')">Copy</button>
            </div>

            <!-- SUMMARY -->
            <section class="summary">
                <div class="label">Team Profit</div>
                <div class="value">{{ $general->cur_sym }}{{ number_format($level1_bonus + $level2_bonus + $level3_bonus) }}
                </div>

                <div class="label" style="margin-top:6px">Total Team Size</div>
                <div class="value">{{ $level1->count() + $level2->count() + $level3->count() }} people</div>

                <div class="grid">
                    <div class="box">
                        <div class="label">Total Recharge</div>
                        <b>{{ $general->cur_sym }}{{ number_format(teamDeposit($user->id, 1) + teamDeposit($user->id, 2) + teamDeposit($user->id, 3)) }}</b>
                    </div>
                    <div class="box">
                        <div class="label">Team-1 Active</div>
                        <b>{{ $level1active->count() }}</b>
                    </div>
                </div>
            </section>

            <!-- LEVELS: 1, 2, and 3 -->
            <article class="level">
                <div class="head">
                    <div class="name">Level – 1</div>
                    <div class="pill">{{ $general->lv1 }}% commission</div>
                </div>
                <div class="meta">
                    <div class="col">People<b>{{ $level1->count() }}</b></div>
                    <div class="col">Commission<b>{{ $general->cur_sym }}{{ number_format($level1_bonus) }}</b></div>
                    <div class="col">Deposit<b>{{ $general->cur_sym }}{{ number_format(teamDeposit($user->id, 1)) }}</b></div>
                </div>
                <button class="view" onclick="location.replace('{{ route('user.referrals.lv1') }}')">View Team</button>
            </article>
            <article class="level">
                <div class="head">
                    <div class="name">Level – 2</div>
                    <div class="pill">{{ $general->lv2 }}% commission</div>
                </div>
                <div class="meta">
                    <div class="col">People<b>{{ $level2->count() }}</b></div>
                    <div class="col">Commission<b>{{ $general->cur_sym }}{{ number_format($level2_bonus) }}</b></div>
                    <div class="col">Deposit<b>{{ $general->cur_sym }}{{ number_format(teamDeposit($user->id, 2)) }}</b></div>
                </div>
                <button class="view" onclick="location.replace('{{ route('user.referrals.lv2') }}')">View Team</button>
            </article>
            <article class="level">
                <div class="head">
                    <div class="name">Level – 3</div>
                    <div class="pill">{{ $general->lv3 }}% commission</div>
                </div>
                <div class="meta">
                    <div class="col">People<b>{{ $level3->count() }}</b></div>
                    <div class="col">Commission<b>{{ $general->cur_sym }}{{ number_format($level3_bonus) }}</b></div>
                    <div class="col">Deposit<b>{{ $general->cur_sym }}{{ number_format(teamDeposit($user->id, 3)) }}</b></div>
                </div>
                <button class="view" onclick="location.replace('{{ route('user.referrals.lv3') }}')">View Team</button>
            </article>

            <div id="bottom-spacer" class="bottom-spacer" style="height: 62px;"></div>
            <div class="toast" id="toast">Copied!</div>
        </div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')

        <script>
            const toast = document.getElementById('toast');

            function copyText(sel) {
                const t = document.querySelector(sel)?.textContent?.trim() || '';
                if (!t) return;
                navigator.clipboard.writeText(t).then(() => {
                    showToast('Copied!');
                });
            }

            function showToast(msg) {
                toast.textContent = msg;
                toast.style.display = 'block';
                clearTimeout(window.__t);
                window.__t = setTimeout(() => toast.style.display = 'none', 1400);
            }

            function syncBottomSpacer() {
                const bar = document.getElementById('tabbar');
                const spacer = document.getElementById('bottom-spacer');
                if (!bar || !spacer) return;
                const h = Math.ceil(bar.getBoundingClientRect().height);
                spacer.style.height = h + 'px';
            }
            window.addEventListener('load', syncBottomSpacer);
            window.addEventListener('resize', syncBottomSpacer);
            window.addEventListener('orientationchange', syncBottomSpacer);
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4d4f2bac68d9e0&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>

    <script>
        function copyToClipboard(elementId) {
            const input = document.getElementById(elementId);

            // Create a temporary input to ensure compatibility
            const tempInput = document.createElement("input");
            tempInput.style.position = "absolute";
            tempInput.style.left = "-9999px";
            tempInput.value = input.value;
            document.body.appendChild(tempInput);
            tempInput.select();

            try {
                const successful = document.execCommand("copy");
                if (successful) {
                    message("Copied Successfully!");
                } else {
                    alert("Copy command failed.");
                }
            } catch (err) {
                console.error("Copy error:", err);
                alert("Failed to copy.");
            }

            document.body.removeChild(tempInput);
        }
    </script>
@endsection
