@extends('layouts.users')



@section('content')
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --accent1: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --ink: #3b2613;
            /* main text */
            --muted: #7a6a58;
            /* secondary text */
            --page: #f7f2e9;
            /* paper background */
            --panel: #fffaf2;
            /* cards */
            --line: rgba(0, 0, 0, .08);
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0
        }

        html,
        body {
            height: 100%
        }

        body {
            font-family: "Segoe UI", system-ui, -apple-system, Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--page);
            display: flex;
            justify-content: center;
            padding: 18px 16px calc(var(--tabbar-h) + var(--safe-bottom) + 16px);
        }

        .wrap {
            width: 100%;
            max-width: 540px
        }

        /* Hero Banner */
        .hero {
            background:
                linear-gradient(180deg, rgba(255, 255, 255, .95), rgba(247, 238, 227, .95)),
                radial-gradient(100% 80% at 50% -20%, rgba(214, 162, 94, .18), rgba(255, 255, 255, .9));
            color: var(--ink);
            border-radius: 20px;
            padding: 22px 18px 26px;
            box-shadow: 0 12px 26px rgba(184, 115, 51, .20);
            text-align: center;
            font-weight: 900;
            letter-spacing: .3px;
        }

        .hero small {
            display: block;
            color: var(--muted);
            font-weight: 600;
            margin-top: 6px;
        }

        /* Card */
        .card {
            background: var(--panel);
            border: 1px solid var(--line);
            border-radius: 18px;
            box-shadow: 0 12px 26px rgba(0, 0, 0, .08);
            padding: 18px;
            margin-top: 16px;
        }

        .title {
            font-weight: 900;
            font-size: 17px;
            color: var(--accent1);
            margin-bottom: 12px;
            letter-spacing: .2px;
        }

        /* Invite Box */
        .invite-box {
            background: rgba(184, 115, 51, .06);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 14px;
            word-break: break-all;
            box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .04);
        }

        .invite-box a {
            color: var(--accent1);
            text-decoration: none;
            font-weight: 800;
            word-break: break-word;
        }

        .invite-code {
            color: var(--muted);
            margin-top: 10px;
            font-weight: 600;
        }

        /* Buttons */
        .invite-buttons {
            display: flex;
            gap: 10px;
            margin-top: 16px;
        }

        .btn {
            flex: 1;
            border: 0;
            cursor: pointer;
            border-radius: 14px;
            padding: 12px 14px;
            font-weight: 900;
            color: white;
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            box-shadow: 0 10px 24px rgba(184, 115, 51, .22);
            transition: transform .05s ease, filter .2s ease;
        }

        .btn:active {
            transform: translateY(1px) scale(.995)
        }

        .btn:hover {
            filter: brightness(1.05)
        }

        .btn.outline {
            background: transparent;
            color: var(--accent1);
            border: 1.5px solid var(--accent1);
            box-shadow: none;
        }

        /* Notice */
        .notice {
            margin-top: 18px;
            background: rgba(214, 162, 94, .08);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 14px;
            color: var(--muted);
            line-height: 1.6;
            font-size: 14px;
        }

        .notice b {
            color: var(--accent1);
            font-weight: 800
        }

        /* Toast */
        #copyMessage {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: calc(var(--tabbar-h) + var(--safe-bottom) + 18px);
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            padding: 10px 18px;
            border-radius: 999px;
            font-weight: 900;
            display: none;
            z-index: 9999;
            box-shadow: 0 10px 28px rgba(184, 115, 51, .25);
        }

        /* Tab Bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(8px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent1)
        }

        .tab.active .ico {
            color: var(--accent1)
        }
    </style>

    <body>

        <div class="wrap">
            <section class="hero">
                Invite Friends
                <small>Share your exclusive referral link</small>
            </section>

            <section class="card">
                <div class="title">Invitation Link Address</div>

                <div class="invite-box">
                    <a
                        href="{{ route('home') }}?shareCode={{ auth()->user()->ref_code }}">{{ route('home') }}?shareCode={{ auth()->user()->ref_code }}</a>
                    <div class="invite-code">
                        Invitation Code: <b id="inviteCode">{{ auth()->user()->ref_code }}</b>
                    </div>
                </div>

                <div class="invite-buttons">
                    <button class="btn" onclick="copyLink()">Copy Link</button>
                    <button class="btn outline" onclick="copyCode()">Copy Code</button>
                </div>

                <div class="notice">
                    <b>Notice</b><br>
                    1. Copy your exclusive invitation link or code to invite your friends.<br>
                    2. When your friends join your team, you’ll earn commissions.<br>
                </div>
            </section>
        </div>

        <div id="copyMessage">Copied!</div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')

        <script>
            function showToast(txt) {
                const msg = document.getElementById('copyMessage');
                msg.textContent = txt || 'Copied!';
                msg.style.display = 'block';
                clearTimeout(window.__toast);
                window.__toast = setTimeout(() => msg.style.display = 'none', 1500);
            }

            function copyLink() {
                const link = "{{ route('home') }}?shareCode={{ auth()->user()->ref_code }}";
                navigator.clipboard.writeText(link).then(() => showToast('Link copied!'));
            }

            function copyCode() {
                const code = "{{ auth()->user()->ref_code }}";
                navigator.clipboard.writeText(code).then(() => showToast('Code copied!'));
            }

            document.addEventListener('DOMContentLoaded', function() {
                const combined = window.location.pathname + window.location.search;
                const match = combined.match(/sign\?code=([\w-]+)/);
                if (match) {
                    const code = match[1];
                    window.location.href = "?shareCode=" + code;
                }
            });
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4ce0f76d64fba2&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
@endsection


@push('script')
    <script type="text/javascript">
        var text = '{{ route('home') }}?shareCode={{ auth()->user()->ref_code }}';
        $('.btncopy').click(function() {
            copy(text)
        });
    </script>
@endpush
