@extends('layouts.users')


@section('content')
    <style>
        :root {
            /* Coffeehouse palette */
            --ink: #3b2613;
            /* primary text */
            --muted: #7a6a58;
            /* secondary text */
            --bg: #f7f2e9;
            /* paper */
            --panel: #fffaf2;
            /* card background */
            --panel-2: #f3e7d8;
            /* gradient stop */
            --line: rgba(0, 0, 0, .08);
            /* subtle borders */
            --ring: #e9dcc7;
            /* soft ring */
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --tabbar-h: 62px;
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('') center/cover no-repeat,
                var(--bg);
            display: flex;
            justify-content: center;
        }

        .app {
            width: 100%;
            max-width: 560px;
            min-height: 100dvh;
            padding: 14px 14px 16px;
        }

        /* ===== Identity Card ===== */
        .idcard {
            display: flex;
            align-items: center;
            gap: 12px;
            background:
                radial-gradient(140% 120% at 100% -20%, rgba(214, 162, 94, .18), transparent 40%),
                linear-gradient(180deg, var(--panel), var(--panel-2));
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 14px;
            box-shadow: 0 12px 28px rgba(0, 0, 0, .05);
            margin-bottom: 14px;
        }

        .idcard img {
            width: 52px;
            height: 52px;
            border-radius: 12px;
            background: #fff2de;
            object-fit: cover
        }

        .id-main {
            flex: 1
        }

        .id-main .uid {
            font-weight: 900;
            letter-spacing: .3px
        }

        .id-main .inv {
            font-size: 12px;
            color: var(--muted);
            margin-top: 4px
        }

        .copy {
            display: grid;
            place-items: center;
            width: 40px;
            height: 40px;
            border-radius: 12px;
            border: 1px solid var(--line);
            background: linear-gradient(180deg, #ffffff, #fff4e5);
            cursor: pointer;
        }

        .ico {
            width: 18px;
            height: 18px;
            color: var(--accent)
        }

        /* ===== Balance + quick actions ===== */
        .balance {
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: #ffffff;
            border-radius: 20px;
            padding: 16px;
            margin-bottom: 14px;
            box-shadow: 0 16px 36px rgba(184, 115, 51, .22);
        }

        .balance .title {
            opacity: .95;
            font-weight: 800;
            letter-spacing: .2px
        }

        .balance .amount {
            font-size: 28px;
            font-weight: 900;
            margin: 6px 0 10px;
            color: #ffffff
        }

        .hr {
            height: 1px;
            background: rgba(255, 255, 255, .28);
            margin: 10px 0 12px
        }

        .bal-actions {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px
        }

        .bal-actions .btn {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            border: 0;
            border-radius: 14px;
            height: 44px;
            cursor: pointer;
            font-weight: 900;
            letter-spacing: .2px;
            background: rgba(255, 255, 255, .22);
            color: #fff;
            transition: all .2s;
        }

        .bal-actions .btn:hover {
            background: rgba(255, 255, 255, .35)
        }

        /* ===== Quick Grid ===== */
        .quick {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-bottom: 14px;
        }

        .qtile {
            border-radius: 16px;
            padding: 12px;
            text-decoration: none;
            color: var(--ink);
            background:
                radial-gradient(140% 120% at 100% -20%, rgba(214, 162, 94, .15), transparent 40%),
                linear-gradient(180deg, var(--panel), var(--panel-2));
            border: 1px solid var(--line);
            box-shadow: 0 10px 24px rgba(0, 0, 0, .05);
            display: grid;
            gap: 8px;
            place-items: start;
        }

        .qico {
            width: 22px;
            height: 22px;
            color: var(--accent)
        }

        .qtitle {
            font-size: 12px;
            color: var(--muted);
            font-weight: 700
        }

        /* ===== List Section ===== */
        .list {
            background:
                radial-gradient(140% 120% at 100% -20%, rgba(214, 162, 94, .10), transparent 40%),
                linear-gradient(180deg, #fffaf2, #f7efe3);
            border: 1px solid var(--line);
            border-radius: 18px;
            padding: 6px 8px;
            box-shadow: 0 12px 28px rgba(0, 0, 0, .05);
        }

        .item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            border-radius: 12px;
            color: var(--ink);
            text-decoration: none;
        }

        .item+.item {
            border-top: 1px solid var(--line)
        }

        .bullet {
            width: 36px;
            height: 36px;
            border-radius: 999px;
            display: grid;
            place-items: center;
            background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, .85), rgba(214, 162, 94, .15) 60%),
                linear-gradient(180deg, #ffffff, #fff6e8);
            border: 1px solid var(--line);
        }

        .label {
            flex: 1
        }

        .label b {
            display: block;
            font-size: 15px
        }

        .sub {
            font-size: 12px;
            color: var(--muted)
        }

        .chev {
            color: var(--accent)
        }

        /* Toast */
        .toast {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 14px);
            background: rgba(184, 115, 51, .95);
            color: #fff;
            border: none;
            padding: 10px 14px;
            border-radius: 12px;
            display: none;
            box-shadow: 0 10px 22px rgba(184, 115, 51, .28);
            z-index: 50;
            font-weight: 800;
            font-size: 13px;
        }

        /* Bottom Tab Bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 560px;
            height: calc(var(--tabbar-h) + env(safe-area-inset-bottom));
            padding-bottom: env(safe-area-inset-bottom);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 40;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent)
        }

        .tab.active .ico {
            color: var(--accent)
        }

        /* Spacer */
        .bottom-spacer {
            height: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 12px);
        }

        /* Modal */
        .modal {
            position: fixed;
            inset: 0;
            display: none;
            place-items: center;
            background: rgba(0, 0, 0, .25);
            z-index: 60;
            padding: 18px;
        }

        .modal-card {
            width: min(440px, 100%);
            border-radius: 18px;
            overflow: hidden;
            background: linear-gradient(180deg, #ffffff, #fff4e7);
            border: 1px solid var(--line);
            box-shadow: 0 24px 60px rgba(184, 115, 51, .22);
            color: var(--ink);
            position: relative;
        }

        .modal-head {
            padding: 14px;
            font-weight: 900;
            letter-spacing: .3px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: #fff;
        }

        .close-x {
            position: absolute;
            top: 8px;
            right: 10px;
            font-size: 26px;
            line-height: 1;
            color: #fff;
            cursor: pointer;
            border: none;
            background: transparent;
        }

        .modal-list {
            padding: 6px 8px
        }

        .modal-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            border-radius: 12px;
            text-decoration: none;
            color: var(--ink);
        }

        .modal-link+.modal-link {
            border-top: 1px solid var(--line)
        }

        .modal-link .bullet {
            width: 34px;
            height: 34px
        }

        .modal-link .txt {
            flex: 1;
            font-weight: 800
        }

        .modal-link .arr {
            color: var(--muted)
        }

        @media (max-width:380px) {
            .idcard img {
                width: 46px;
                height: 46px
            }
        }
    </style>


    <body>
        <div class="app">

            <!-- ID / INVITE -->
            <section class="idcard">
                <img src="https://i.imgur.com/d5CfWPm.jpeg" alt="Avatar">
                <div class="id-main">
                    <div class="uid">{{ $general->country_code }} {{ $user->mobile }}</div>
                    <div class="inv">Deposit Balance: <span id="invite">{{ $general->cur_sym }}{{ number_format(auth()->user()->balance) }}</span></div>
                </div>
                <button class="copy" id="copyBtn" aria-label="Copy balance">
                    <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                        <path
                            d="M16 1H8a2 2 0 00-2 2v2h2V3h8v6h2V3a2 2 0 00-2-2zM5 7h10a2 2 0 012 2v10a2 2 0 01-2 2H5a2 2 0 01-2-2V9a2 2 0 012-2zm0 2v10h10V9H5z">
                        </path>
                    </svg>
                </button>
            </section>

            <!-- BALANCE -->
            <section class="balance">
                <div class="title">Current balance</div>
                <div class="amount">{{ $general->cur_sym }}{{ number_format(auth()->user()->balance + auth()->user()->bonus_balance, 2) }}</div>
                <div class="hr"></div>
                <div class="bal-actions">
                    <button class="btn" onclick="window.location.href='{{ route('user.deposit') }}'">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M7 7h5V3l6 6-6 6v-4H7V7z"></path>
                        </svg>
                        Recharge
                    </button>
                    <button class="btn" onclick="window.location.href='{{ route('user.withdraw') }}'">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M17 7H7V3L1 9l6 6v-4h10v6h2V7z"></path>
                        </svg>
                        Withdraw
                    </button>
                </div>
            </section>

            <!-- QUICK GRID -->
            <section class="quick" aria-label="Quick shortcuts">
                <a class="qtile" href="{{ route('user.referrals') }}" onclick="window.location.href='{{ route('user.referrals') }}'; return false;">
                    <svg class="qico" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 12a4 4 0 10-4-4 4 4 0 004 4zm-7 8a7 7 0 0114 0z"></path>
                    </svg>
                    <div class="qtitle">Team</div>
                    <strong style="color:var(--accent2)">Overview</strong>
                </a>
                <a class="qtile" href="{{ route('user.link') }}" onclick="window.location.href='{{ route('user.link') }}'; return false;">
                    <svg class="qico" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M18 8h-4V3H4a2 2 0 00-2 2v14l4-4h12a2 2 0 002-2V10a2 2 0 00-2-2z"></path>
                    </svg>
                    <div class="qtitle">Share</div>
                    <strong style="color:var(--accent2)">Invite</strong>
                </a>
                <a class="qtile" href="{{ route('user.coupon') }}" onclick="window.location.href='{{ route('user.coupon') }}'; return false;">
                    <svg class="qico" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2l3 7h7l-5.5 4.1L19 20l-7-4.5L5 20l2.5-6.9L2 9h7z"></path>
                    </svg>
                    <div class="qtitle">Bonus</div>
                    <strong style="color:var(--accent2)">Rewards</strong>
                </a>
            </section>

            <!-- LIST -->
            <section class="list">

                <a class="item" href="#">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Application</b><span class="sub">download now</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="window.location.href='{{ route('user.deposit.history') }}'">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Deposit history</b><span class="sub">recharges details</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="window.location.href='{{ route('user.withdraw.history') }}'">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Withdraw history</b><span class="sub">Withdraw details</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="window.location.href='{{ route('user.trx.log') }}'">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Income history</b><span class="sub">Income details</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="window.location.href='{{ route('user.account-setup') }}'">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Bank account</b><span class="sub">Bind your wallet details</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="window.location.href='{{ route('user.investment.log') }}'">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 2a8 8 0 00-8 8v3a3 3 0 003 3h1v-6H6a6 6 0 1112 0h-2v6h1a3 3 0 003-3v-3a8 8 0 00-8-8z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Ordered</b><span class="sub">Order details</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="{{ $general->telegram_group }}">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 1a5 5 0 00-5 5v3H6a2 2 0 00-2 2v8h16v-8a2 2 0 00-2-2h-1V6a5 5 0 00-5-5zM9 9V6a3 3 0 116 0v3H9z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Official Group</b><span class="sub">Group discussion</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="{{ $general->cs }}">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path
                                d="M12 1a5 5 0 00-5 5v3H6a2 2 0 00-2 2v8h16v-8a2 2 0 00-2-2h-1V6a5 5 0 00-5-5zM9 9V6a3 3 0 116 0v3H9z">
                            </path>
                        </svg></div>
                    <div class="label"><b>Support</b><span class="sub">Help</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>

                <a class="item" href="#" onclick="location.replace('{{ route('user.logout') }}');return false;">
                    <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M10 3h9a2 2 0 012 2v14a2 2 0 01-2 2h-9v-2h9V5h-9V3zM11 11H3v2h8v3l5-4-5-4v3z"></path>
                        </svg></div>
                    <div class="label"><b>Log out</b><span class="sub">Sign out of your account</span></div>
                    <svg class="ico chev" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6l6 6-6 6"></path>
                    </svg>
                </a>
            </section>

            <div class="toast" id="toast" style="display: none;">Copied: ₱0</div>

            <!-- Spacer -->
            <div id="bottom-spacer" class="bottom-spacer" style="height: 74px;"></div>
        </div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')

        <!-- Income Modal -->
        <div class="modal" id="incomeModal" aria-hidden="true">
            <div class="modal-card" role="dialog" aria-modal="true" aria-labelledby="incomeTitle">
                <div class="modal-head" id="incomeTitle">Income Details</div>
                <button class="close-x" onclick="closeIncomeModal()" aria-label="Close">×</button>
                <div class="modal-list">
                    <a class="modal-link" href="#" onclick="location.replace('/deposit/history');return false;">
                        <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M7 7h5V3l6 6-6 6v-4H7V7z"></path>
                            </svg></div>
                        <div class="txt">Deposit record</div>
                        <svg class="ico arr" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 6l6 6-6 6"></path>
                        </svg>
                    </a>
                    <a class="modal-link" href="#" onclick="location.replace('/withdraw/history');return false;">
                        <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M17 7H7V3L1 9l6 6v-4h10v6h2V7z"></path>
                            </svg></div>
                        <div class="txt">Withdraw record</div>
                        <svg class="ico arr" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 6l6 6-6 6"></path>
                        </svg>
                    </a>
                    <a class="modal-link" href="#" onclick="location.replace('/income');return false;">
                        <div class="bullet"><svg class="ico" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 3h18v4H3zM3 9h18v12H3zM7 12h4v6H7z"></path>
                            </svg></div>
                        <div class="txt">Earnings record</div>
                        <svg class="ico arr" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 6l6 6-6 6"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>

        <script>
            // Copy value with toast
            const copyBtn = document.getElementById('copyBtn');
            if (copyBtn) {
                copyBtn.addEventListener('click', async () => {
                    const code = document.getElementById('invite').textContent.trim();
                    try {
                        await navigator.clipboard.writeText(code);
                    } catch (e) {
                        /* ignore */
                    }
                    const t = document.getElementById('toast');
                    t.textContent = 'Copied: ' + code;
                    t.style.display = 'block';
                    clearTimeout(window.__toast);
                    window.__toast = setTimeout(() => t.style.display = 'none', 1600);
                });
            }

            // Income modal controls
            const modal = document.getElementById('incomeModal');

            function openIncomeModal() {
                modal.style.display = 'grid';
                modal.setAttribute('aria-hidden', 'false');
            }

            function closeIncomeModal() {
                modal.style.display = 'none';
                modal.setAttribute('aria-hidden', 'true');
            }
            modal.addEventListener('click', (e) => {
                if (e.target === modal) closeIncomeModal();
            });
            window.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') closeIncomeModal();
            });

            // Ensure spacer matches the real tabbar height
            function syncBottomSpacer() {
                const bar = document.getElementById('tabbar');
                const spacer = document.getElementById('bottom-spacer');
                if (!bar || !spacer) return;
                const h = Math.ceil(bar.getBoundingClientRect().height);
                spacer.style.height = (h + 12) + 'px'; // breathing room
            }
            window.addEventListener('load', syncBottomSpacer);
            window.addEventListener('resize', syncBottomSpacer);
            window.addEventListener('orientationchange', syncBottomSpacer);
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4ce7ed0d827765&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
@endsection
