@extends('layouts.users')


@section('content')
    <style>
        :root {
            /* ☕ Coffeehouse Theme */
            --page: #f7f2e9;
            /* paper */
            --panel: #fffaf2;
            /* card */
            --ink: #3b2613;
            /* text */
            --muted: #7a6a58;
            /* secondary text */
            --line: rgba(0, 0, 0, .08);
            /* borders */
            --accent1: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --shadow: 0 12px 28px rgba(184, 115, 51, .20);
            --tabbar-h: 62px;
            --safe-bottom: env(safe-area-inset-bottom, 0px);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0
        }

        html,
        body {
            height: 100%
        }

        body {
            font-family: "Segoe UI", system-ui, -apple-system, Roboto, Arial, sans-serif;
            color: var(--ink);
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--page);
            display: flex;
            justify-content: center;
        }

        .wrap {
            width: 100%;
            max-width: 540px;
            padding: 12px 14px 24px
        }

        /* Header */
        .top {
            position: sticky;
            top: 0;
            padding: 12px 0;
            text-align: center;
            z-index: 10;
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--line);
            box-shadow: 0 2px 6px rgba(184, 115, 51, .12);
        }

        .title {
            font-size: 22px;
            font-weight: 900;
            letter-spacing: .3px;
            color: var(--accent1);
            text-shadow: 0 0 8px rgba(184, 115, 51, .18);
        }

        /* Messages */
        .message-box {
            margin-top: 10px;
            background: var(--panel);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 10px 12px;
            box-shadow: var(--shadow);
        }

        .success {
            color: var(--accent1);
            font-weight: 700
        }

        .error {
            color: #c0433a;
            font-weight: 700
        }

        /* Section Titles */
        .section {
            margin-top: 16px
        }

        .label {
            font-weight: 900;
            color: var(--accent1);
            margin-bottom: 8px;
            letter-spacing: .2px
        }

        /* Cards */
        .card {
            background: linear-gradient(180deg, #ffffff, #fff4e7);
            border: 1px solid var(--line);
            border-radius: 16px;
            padding: 14px;
            box-shadow: var(--shadow);
        }

        .asset .value {
            color: var(--accent1);
            font-weight: 900;
            font-size: 24px
        }

        /* Input */
        .inputwrap {
            position: relative;
            border: 1px solid var(--line);
            border-radius: 12px;
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            overflow: hidden;
            box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .03);
        }

        .inputwrap input {
            width: 100%;
            padding: 12px 44px 12px 12px;
            border: 0;
            outline: none;
            background: transparent;
            color: var(--ink);
            font-size: 16px;
            font-weight: 600;
        }

        .currency {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--muted);
            font-weight: 800;
        }

        /* Chips */
        .chips {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-top: 12px;
        }

        .chip {
            height: 44px;
            border-radius: 10px;
            display: grid;
            place-items: center;
            cursor: pointer;
            border: 1.5px solid var(--accent1);
            color: var(--ink);
            font-weight: 800;
            background: rgba(255, 250, 242, .8);
            transition: all .2s ease;
        }

        .chip:hover {
            border-color: var(--accent2);
            color: var(--accent1)
        }

        .chip.active {
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            color: white;
            border-color: transparent;
            box-shadow: 0 8px 20px rgba(184, 115, 51, .28);
        }

        /* Select */
        .selectwrap {
            position: relative;
            margin-top: 6px
        }

        select {
            width: 100%;
            height: 48px;
            border-radius: 12px;
            border: 1px solid var(--line);
            padding: 0 40px 0 12px;
            background: linear-gradient(180deg, #ffffff, #fff3e2);
            color: var(--ink);
            font-weight: 700;
            appearance: none;
            outline: none;
        }

        .selectwrap .chev {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--muted);
            pointer-events: none;
        }

        /* Button */
        .btn {
            width: 100%;
            height: 50px;
            margin-top: 18px;
            border: 0;
            cursor: pointer;
            border-radius: 14px;
            font-weight: 900;
            font-size: 16px;
            letter-spacing: .2px;
            color: white;
            background: linear-gradient(90deg, var(--accent1), var(--accent2));
            box-shadow: 0 16px 32px rgba(184, 115, 51, .25);
            transition: transform .1s ease, filter .2s ease;
        }

        .btn:hover {
            filter: brightness(1.06);
            transform: translateY(-1px)
        }

        .btn:active {
            transform: translateY(0)
        }

        /* Instructions */
        .instructions {
            margin-top: 18px
        }

        .ins-title {
            font-weight: 900;
            color: var(--accent1);
            margin-bottom: 8px
        }

        .ins p {
            color: var(--muted);
            line-height: 1.6;
            margin: 8px 0
        }

        .ins b {
            color: var(--accent1)
        }

        /* Tab bar */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 540px;
            height: calc(var(--tabbar-h) + var(--safe-bottom));
            padding-bottom: var(--safe-bottom);
            background: rgba(255, 250, 242, .95);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--line);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            z-index: 45;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px;
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent1)
        }

        .tab.active .ico {
            color: var(--accent1)
        }
    </style>

    <body>
        <div class="wrap">

            <div class="top">
                <div class="title">Deposit</div>
            </div>


            <!-- Asset Balance -->
            <div class="section">
                <div class="label">Asset Balance</div>
                <div class="card asset">
                    <div class="value">{{ $general->cur_sym }}{{ number_format(auth()->user()->balance, 2) }}</div>
                </div>
            </div>

            <!-- Amount -->
            <div class="section">
                <div class="label">Amount</div>
                <div class="inputwrap">
                    <input type="number" id="amount" name="amount" placeholder="Please enter the deposit amount">
                    <span class="currency">{{ $general->cur_sym }}</span>
                </div>

                <div class="chips" id="chips">
                    <button type="button" class="chip">300</button>
                    <button type="button" class="chip">500</button>
                    <button type="button" class="chip">1500</button>
                    <button type="button" class="chip">2000</button>
                    <button type="button" class="chip">3000</button>
                    <button type="button" class="chip">4000</button>
                    <button type="button" class="chip">7500</button>
                    <button type="button" class="chip">10000</button>
                    <button type="button" class="chip">20000</button>
                </div>
            </div>

            <!-- Payment Channel -->
            <div class="section">
                <div class="label">Payment Channel</div>
                <div class="selectwrap">
                    <select id="channel" name="gateway" aria-label="Payment Channel">
                        <option value="gcash" selected="">Gcash</option>
                        <option value="paymaya">Maya</option>
                    </select>
                    <svg class="chev" width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M7 10l5 5 5-5"></path>
                    </svg>
                </div>
                <button class="btn" onclick="submitRecharge()">Deposit</button>
            </div>

            <!-- Instructions -->
            <div class="instructions">
                <div class="ins-title">Deposit Instructions:</div>
                <div class="ins">
                    <p>1. Minimum deposit amount: <b>{{ $general->cur_sym }}300.00</b>.</p>
                    <p>2. After payment, if the amount is not reflected after 20 minutes, please contact support.</p>
                    <p>3. Deposits can only be done through the platform's deposit gateway. Do not trade privately.</p>
                </div>
            </div>
        </div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')
        </nav>

        <script>
            let selectedMethod = document.getElementById('channel').value;
            const amountInput = document.getElementById('amount');
            document.querySelectorAll('.chip').forEach(btn => {
                btn.addEventListener('click', () => {
                    document.querySelectorAll('.chip').forEach(b => b.classList.remove('active'));
                    btn.classList.add('active');
                    amountInput.value = btn.textContent.trim();
                });
            });
            document.getElementById('channel').addEventListener('change', e => selectedMethod = e.target.value);

            function submitRecharge() {
                const amountInput = document.getElementById('amount');
                const channelSelect = document.getElementById('channel');

                const amount = parseFloat((amountInput.value || '').trim());
                const channel = channelSelect.value;

                // Validate amount
                if (isNaN(amount) || amount < 300 || amount > 49999) {
                    return alert('Please enter a valid amount between {{ $general->cur_sym }}300 and {{ $general->cur_sym }}49,999.');
                }

                // Validate payment method
                if (!channel) {
                    return alert('Please select a payment method.');
                }

                // Create form dynamically
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = "{{ route('user.deposit.shpay') }}";
                form.style.display = 'none';

                // CSRF token
                const csrf = document.createElement('input');
                csrf.type = 'hidden';
                csrf.name = '_token';
                csrf.value = '{{ csrf_token() }}';

                // Amount
                const amountHidden = document.createElement('input');
                amountHidden.type = 'hidden';
                amountHidden.name = 'amount';
                amountHidden.value = amount;

                // Gateway
                const gatewayHidden = document.createElement('input');
                gatewayHidden.type = 'hidden';
                gatewayHidden.name = 'gateway';
                gatewayHidden.value = channel;

                // Append inputs and submit
                form.append(csrf, amountHidden, gatewayHidden);
                document.body.appendChild(form);
                form.submit();
            }
        </script>
        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4a652dcae394fd&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
@endsection
