@extends('layouts.users')


@section('content')
    <style>
        :root {
            /* Coffeehouse palette */
            --ink: #3b2613;
            /* primary text */
            --muted: #7a6a58;
            /* secondary text */
            --bg: #f7f2e9;
            /* paper */
            --panel: #fffaf2;
            /* card */
            --panel-2: #f3e7d8;
            /* tint */
            --line: rgba(0, 0, 0, .08);
            --ring: #e9dcc7;
            /* badge ring */
            --accent: #b87333;
            /* caramel */
            --accent2: #d6a25e;
            /* latte */
            --danger: #ff5a5f;
            --tabbar-h: 66px;
        }

        * {
            box-sizing: border-box;
        }

        html,
        body {
            height: 100%;
        }

        body {
            margin: 0;
            color: var(--ink);
            font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
            background:
                radial-gradient(800px 500px at 50% 10%, rgba(255, 255, 255, .75), rgba(255, 255, 255, .25) 60%, transparent 70%),
                url('https://i.imgur.com/d5CfWPm.jpeg') center/cover no-repeat,
                var(--bg);
            display: flex;
            justify-content: center;
        }

        /* App frame */
        .app {
            width: 100%;
            max-width: 560px;
            min-height: 100dvh;
            display: flex;
            flex-direction: column;
            padding-bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 16px);
        }

        /* HERO BADGE */
        .hero {
            padding: 18px 14px 0;
        }

        .badge-head {
            background: linear-gradient(180deg, var(--panel), #fff9f0);
            border: 1px solid var(--line);
            border-radius: 20px;
            box-shadow: 0 10px 28px rgba(184, 115, 51, .12);
            padding: 18px 16px;
            display: grid;
            gap: 10px;
            justify-items: center;
            position: relative;
            overflow: hidden;
        }

        /* subtle ring */
        .badge-head::before {
            content: "";
            position: absolute;
            inset: -30%;
            background: radial-gradient(60% 40% at 50% 0%, var(--ring), transparent 60%);
            pointer-events: none;
        }

        .brand {
            font-weight: 900;
            letter-spacing: .4px;
            color: var(--ink);
            font-size: 18px;
        }

        .badge {
            width: 86%;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 0, 0, .08), transparent);
        }

        .plate {
            font-size: 12px;
            font-weight: 800;
            color: var(--muted);
            background: #fff3e2;
            border: 1px solid rgba(184, 115, 51, .22);
            padding: 6px 10px;
            border-radius: 999px;
        }

        /* image “hole” */
        .hero .plane {
            width: 100%;
            height: 140px;
            /* set the badge hole height */
            border-radius: 12px;
            /* match your card rounding */
            overflow: hidden;
            /* clip overflow */
            display: block;
        }

        .hero .plane img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            /* fill fully (may crop slightly) */
            display: block;
            image-rendering: auto;
            filter: none;
            animation: none;
        }

        /* responsive tweak */
        @media (max-width:540px) {
            .hero {
                padding: 14px 12px 0
            }

            .hero .plane {
                height: 120px;
            }
        }

        /* ===== Quick Actions (warm cream buttons) ===== */
        .actions {
            padding: 14px;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 12px
        }

        .action {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            text-decoration: none;
            color: var(--ink)
        }

        .action .bubble {
            width: 62px;
            height: 62px;
            border-radius: 50%;
            display: grid;
            place-items: center;
            background: linear-gradient(145deg, #ffffff, #fff4e7);
            border: 1px solid rgba(0, 0, 0, .05);
            box-shadow: 0 8px 18px rgba(184, 115, 51, .18);
        }

        .action span {
            font-size: 12px;
            color: var(--muted)
        }

        .ico {
            width: 24px;
            height: 24px;
            color: var(--accent)
        }

        /* ===== Flash messages ===== */
        .message-container {
            position: sticky;
            top: 0;
            z-index: 20;
            padding: 8px 14px
        }

        .message-box {
            background: linear-gradient(180deg, #fff7ea, #fdeccf);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 10px 12px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, .06)
        }

        .success {
            color: var(--accent);
            margin: 0;
            font-weight: 700
        }

        .error {
            color: #b24141;
            margin: 0;
            font-weight: 700
        }

        /* ===== Bottom tab bar ===== */
        .tabbar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
            width: 100%;
            max-width: 560px;
            height: var(--tabbar-h);
            background: rgba(255, 250, 242, .92);
            backdrop-filter: blur(10px);
            border-top: 1px solid rgba(0, 0, 0, .06);
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            padding-bottom: env(safe-area-inset-bottom);
            z-index: 45;
        }

        .tab {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 6px;
            text-decoration: none;
            color: var(--muted);
            font-size: 11px
        }

        .tab .ico {
            width: 20px;
            height: 20px
        }

        .tab.active {
            color: var(--accent)
        }

        .tab.active .ico {
            color: var(--accent)
        }

        /* ===== Toast ===== */
        .toast {
            position: fixed;
            left: 50%;
            bottom: calc(var(--tabbar-h) + env(safe-area-inset-bottom) + 14px);
            transform: translateX(-50%);
            background: rgba(255, 255, 255, .95);
            color: var(--ink);
            border: 1px solid rgba(0, 0, 0, .08);
            padding: 10px 14px;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(184, 115, 51, .18);
            display: none;
            z-index: 60;
            font-size: 13px;
            font-weight: 800;
        }

        /* ===== Task/Rewards area ===== */
        .task-container {
            max-width: 760px;
            margin: 0 auto;
            padding: 16px 14px
        }

        .reward-summary {
            margin-top: 16px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: #fff;
            padding: 16px;
            border-radius: 18px;
            box-shadow: 0 8px 22px rgba(184, 115, 51, .22);
            border: 1px solid rgba(255, 255, 255, .25);
        }

        .reward-left {
            flex: 1
        }

        .reward-left .label {
            opacity: .92;
            font-weight: 800
        }

        .reward-left .big {
            font-size: 28px;
            font-weight: 900;
            line-height: 1.1;
            margin-top: 4px
        }

        .reward-right {
            display: grid;
            gap: 6px;
            text-align: right
        }

        .pill {
            display: inline-block;
            padding: 6px 10px;
            border-radius: 999px;
            background: rgba(255, 255, 255, .25);
            border: 1px solid rgba(255, 255, 255, .28);
            font-weight: 800;
            color: #fff;
        }

        .task-header {
            margin-top: 14px;
            background: linear-gradient(180deg, #ffffff, #fff6e9);
            border: 1px solid var(--line);
            color: #5a3a1d;
            padding: 14px;
            border-radius: 14px;
            box-shadow: 0 8px 18px rgba(0, 0, 0, .05);
            font-weight: 900;
            font-size: 14px;
        }

        .task-header small {
            display: block;
            color: var(--muted);
            font-weight: 600;
            margin-top: 6px;
            line-height: 1.35
        }

        .task-card {
            margin-top: 12px;
            background: linear-gradient(180deg, #ffffff, #fff9f0);
            border: 1px solid rgba(0, 0, 0, .06);
            border-radius: 16px;
            padding: 14px;
            box-shadow: 0 8px 18px rgba(0, 0, 0, .05);
            color: var(--ink);
        }

        .task-card h4 {
            margin: 0 0 8px;
            font-size: 16px;
            font-weight: 900
        }

        .task-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 8px 12px;
            font-size: 13px;
            color: var(--muted);
            margin-bottom: 10px
        }

        .meta-chip {
            background: #fff3e2;
            border: 1px solid rgba(184, 115, 51, .22);
            color: #5a3a1d;
            border-radius: 10px;
            padding: 6px 10px;
            font-weight: 800
        }

        .progress-wrap {
            margin: 8px 0 10px
        }

        .progress-line {
            width: 100%;
            height: 10px;
            background: #f0e4d1;
            border-radius: 999px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            width: 0%;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            border-right: 1px solid #00000014;
            transition: width .3s ease;
        }

        .progress-text {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            color: var(--muted);
            margin-top: 6px
        }

        .task-actions {
            display: flex;
            gap: 10px;
            margin-top: 8px
        }

        .btn {
            border: none;
            cursor: pointer;
            padding: 10px 14px;
            border-radius: 12px;
            font-weight: 900;
            letter-spacing: .2px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: #fff;
            box-shadow: 0 6px 16px rgba(184, 115, 51, .18);
        }

        .btn:active {
            transform: translateY(1px)
        }

        .btn[disabled] {
            background: #f3e7d8;
            color: var(--muted);
            box-shadow: none;
            cursor: not-allowed
        }

        .bottom-spacer {
            width: 100%;
        }

        /* ===== WELCOME POPUP (Coffee Blend theme) ===== */
        #welcome-popup {
            position: fixed;
            inset: 0;
            z-index: 999;
            display: none;
            /* shown via JS */
            place-items: center;
            padding: 18px;
            background:
                radial-gradient(65% 65% at 50% 10%, rgba(255, 248, 237, .92), rgba(0, 0, 0, .45));
            backdrop-filter: blur(6px);
            -webkit-backdrop-filter: blur(6px);
            font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
        }

        #welcome-popup .box {
            width: min(480px, 96vw);
            max-height: 90vh;
            overflow: auto;
            background: linear-gradient(180deg, var(--panel), #fff3e2);
            border-radius: 22px;
            border: 1px solid var(--line);
            box-shadow: 0 22px 55px rgba(59, 27, 6, .45);
            padding: 18px 16px 16px;
            position: relative;
            animation: popIn .25s ease-out;
        }

        #welcome-popup .close-x {
            position: absolute;
            top: 10px;
            right: 10px;
            width: 28px;
            height: 28px;
            border-radius: 999px;
            border: 1px solid rgba(0, 0, 0, .06);
            background: rgba(255, 255, 255, .9);
            display: grid;
            place-items: center;
            cursor: pointer;
            color: var(--muted);
            font-size: 16px;
            font-weight: 700;
        }

        #welcome-popup .close-x:active {
            transform: translateY(1px);
        }

        #welcome-popup .tag {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            border-radius: 999px;
            background: #fff8ec;
            border: 1px solid rgba(184, 115, 51, .28);
            font-size: 11px;
            font-weight: 800;
            color: #6a421f;
            margin-bottom: 6px;
        }

        #welcome-popup .tag-dot {
            width: 7px;
            height: 7px;
            border-radius: 999px;
            background: radial-gradient(circle at 30% 30%, #ffeac4, #b87333);
        }

        #welcome-popup h2 {
            margin: 0;
            font-size: 18px;
            font-weight: 900;
            color: #4b2c14;
        }

        #welcome-popup .sub {
            margin-top: 4px;
            font-size: 13px;
            color: var(--muted);
            line-height: 1.4;
        }

        .raffle-list {
            margin-top: 12px;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .raffle-item {
            display: flex;
            gap: 10px;
            padding: 8px 9px;
            border-radius: 14px;
            background: linear-gradient(135deg, #fffdf8, #ffeeda);
            border: 1px solid rgba(184, 115, 51, .16);
        }

        .raffle-thumb {
            flex: 0 0 84px;
            height: 60px;
            border-radius: 12px;
            overflow: hidden;
            background: #d8c2aa;
        }

        .raffle-thumb img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }

        .raffle-copy {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .raffle-title {
            font-size: 13px;
            font-weight: 800;
            color: #4a2e17;
            margin-bottom: 2px;
        }

        .raffle-note {
            font-size: 11px;
            color: var(--muted);
        }

        .welcome-footer {
            margin-top: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .welcome-footer small {
            font-size: 11px;
            color: var(--muted);
        }

        .welcome-btn {
            border: none;
            cursor: pointer;
            padding: 9px 16px;
            border-radius: 999px;
            font-size: 13px;
            font-weight: 900;
            letter-spacing: .2px;
            background: linear-gradient(90deg, var(--accent), var(--accent2));
            color: #fff;
            box-shadow: 0 10px 24px rgba(184, 115, 51, .35);
            white-space: nowrap;
        }

        .welcome-btn:active {
            transform: translateY(1px);
        }

        @keyframes popIn {
            from {
                transform: scale(.94);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }
    </style>

    <body>
        <div class="app">



            <!-- HERO BADGE -->
            <section class="hero">
                <div class="badge-head" aria-hidden="true">
                    <div class="brand">Coffee Blend</div>
                    <div class="badge"></div>
                    <div class="plane">
                        <img src="https://i.pinimg.com/originals/94/3d/63/943d63f1bfdbc133e01d3d6f0d64cc4d.gif"
                            alt="Coffee emblem animation">
                    </div>
                    <div class="plate">Since 1972</div>
                </div>
            </section>

            <!-- QUICK ACTIONS -->
            <nav class="actions" aria-label="Quick actions">
                <a class="action" href="#" onclick="window.location.href='{{ route('user.deposit') }}'">
                    <div class="bubble">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                            <path d="M7 7h5V3l6 6-6 6v-4H7V7zM5 19h14v2H5z"></path>
                        </svg>
                    </div>
                    <span>Recharge</span>
                </a>

                <a class="action" href="#" onclick="window.location.href='{{ route('user.withdraw') }}'">
                    <div class="bubble">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                            <path d="M17 7H7V3L1 9l6 6v-4h10v6h2V7h-2z"></path>
                        </svg>
                    </div>
                    <span>Withdraw</span>
                </a>

                <a class="action" href="#" onclick="window.location.href='{{ route('user.referrals') }}'">
                    <div class="bubble">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                            <path
                                d="M12 12a4 4 0 10-4-4 4 4 0 004 4zm-7 8a7 7 0 0114 0zM19 8a3 3 0 11-3-3 3 3 0 013 3zm-1 12a6.5 6.5 0 00-2.3-4.9 8 8 0 014.3 4.9z">
                            </path>
                        </svg>
                    </div>
                    <span>Team</span>
                </a>

                <a class="action" href="{{ $general->telegram_group }}">
                    <div class="bubble">
                        <svg class="ico" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                            <path d="M10 3h9a2 2 0 012 2v14a2 2 0 01-2 2h-9v-2h9V5h-9V3zM11 11H3v2h8v3l5-4-5-4v3z"></path>
                        </svg>
                    </div>
                    <span>Support</span>
                </a>
            </nav>

            <!-- TASKS BELOW -->
            <div class="task-container">

                <!-- Summary -->
                <section class="reward-summary" aria-label="Rewards summary">
                    <div class="reward-left">
                        <div class="label">Total Reward</div>
                        <div class="big">
                            {{ $general->cur_sym }}{{ number_format($level1_bonus + $level2_bonus + $level3_bonus) }}</div>

                        <div class="label" style="margin-top:10px">Lv1 Active People</div>
                        <div class="big">{{ $level1active }}</div>
                    </div>
                    <div class="reward-right">
                        <span class="pill">Referrals: {{ $level1->count() }}</span>
                        <span class="pill">Team Invest:
                            {{ $general->cur_sym }}{{ number_format(teamDeposit($user->id, 1)) }}</span>
                    </div>
                </section>

                <!-- Header -->
                <div class="task-header">
                    Invitation Tasks
                    <small>(Claim rewards when your Level 1 members invest or purchase a plan and meet the valid team
                        requirement.)</small>
                </div>

                <!-- Tasks -->

                @foreach ($tasks as $task)
                    @php
                        $hasClaimed = in_array($task->reward_amount, $claimedAmounts);
                        $canClaim = $referralsCount >= $task->referral_count && !$hasClaimed;

                        // Calculate progress percentage
                        $progressCount =
                            $referralsCount >= $task->referral_count ? $task->referral_count : $referralsCount;
                        $progressPercent = ($progressCount / $task->referral_count) * 100;
                    @endphp

                    <div class="task-card">
                        <h4>Invite {{ $task->referral_count }} valid members to earn
                            {{ $general->cur_sym }}{{ number_format($task->reward_amount) }}</h4>
                        <div class="task-meta">
                            <span class="meta-chip">Progress:
                                {{ $referralsCount >= $task->referral_count ? $task->referral_count : $referralsCount }}/{{ $task->referral_count }}</span>
                            <span class="meta-chip">Bonus:
                                {{ $general->cur_sym }}{{ number_format($task->reward_amount) }}</span>
                            {{-- <span class="meta-chip">Team Invest: {{ $general->cur_sym }}0</span> --}}
                        </div>

                        <div class="progress-wrap" aria-label="Progress">
                            <div class="progress-line"
                                style="background: #e0e0e0; width: 100%; height: 10px; border-radius: 5px;">
                                <div class="progress-fill" style="width: {{ $progressPercent }}%;">
                                </div>
                            </div>
                            <div class="progress-text">
                                <span>{{ round($progressPercent) }}%</span>
                                <span>{{ $progressCount }} of {{ $task->referral_count }}</span>
                            </div>
                        </div>

                        <div class="task-actions">
                            <button class="btn" @if (!$canClaim) disabled @endif
                                onclick="claimReward({{ $task->referral_count }}, {{ $task->reward_amount }})">
                                {{ $hasClaimed ? 'Completed' : ($canClaim ? 'Claim' : 'Incomplete') }}</button>
                        </div>
                    </div>
                @endforeach



                <div id="bottom-spacer" class="bottom-spacer" aria-hidden="true" style="height: 66px;"></div>
            </div>

        </div>

        <!-- ===== WELCOME POPUP MARKUP ===== -->
        <div id="welcome-popup" style="display: grid;">
            <div class="box">
                <button class="close-x" type="button" onclick="closeWelcomePopup()">×</button>

                <div class="tag">
                    <span class="tag-dot"></span>
                    Weekly Coffee Blend Raffle
                </div>
                <h2>Welcome! Enjoy our Weekly Raffles</h2>
                <p class="sub">
                    Join Coffee Blend’s weekly celebration. Every active member has a chance to be part of these exciting
                    raffles.
                </p>

                <div class="raffle-list">
                    <div class="raffle-item">
                        <div class="raffle-thumb">
                            <img src="https://brent.edu.ph/wp-content/uploads/2025/03/ganza-moment-foodfest.png"
                                alt="Weekly food raffle">
                        </div>
                        <div class="raffle-copy">
                            <div class="raffle-title">Weekly — Food Raffle</div>
                            <div class="raffle-note">Win delicious treats and food bundles for your family.</div>
                        </div>
                    </div>

                    <div class="raffle-item">
                        <div class="raffle-thumb">
                            <img src="https://blog.abenson.com/wp-content/uploads/2024/11/week-10-to-12-chrismasaya-prices-min-1160x594.jpg"
                                alt="Weekly appliances raffle">
                        </div>
                        <div class="raffle-copy">
                            <div class="raffle-title">Weekly — Appliances Raffle</div>
                            <div class="raffle-note">Upgrade your home with exciting appliance prizes.</div>
                        </div>
                    </div>

                    <div class="raffle-item">
                        <div class="raffle-thumb">
                            <img src="https://rankmath.com/wp-content/uploads/2025/02/iPhone-16-Pro-Max-Giveaway.png"
                                alt="Weekly gadget raffle">
                        </div>
                        <div class="raffle-copy">
                            <div class="raffle-title">Weekly — Gadget Raffle</div>
                            <div class="raffle-note">Chance to win the latest gadgets and devices.</div>
                        </div>
                    </div>

                    <div class="raffle-item">
                        <div class="raffle-thumb">
                            <img src="https://us.123rf.com/450wm/ppart/ppart1704/ppart170400328/76599882-philippines-money-isolated-on-white-background-3d-illustration.jpg"
                                alt="Weekly cash raffle">
                        </div>
                        <div class="raffle-copy">
                            <div class="raffle-title">Weekly — Cash Raffle</div>
                            <div class="raffle-note">Win exciting cash prizes straight to your wallet.</div>
                        </div>
                    </div>

                    <div class="raffle-item">
                        <div class="raffle-thumb">
                            <img src="https://media.istockphoto.com/id/156820292/vector/christmas-sale-tickets-with-the-mistletoe.jpg?s=612x612&amp;w=0&amp;k=20&amp;c=UdQijwckTnKt3N4kcbzfyihsRR8zMTFTsDMZnE7iqbM="
                                alt="Weekly christmas gift raffle">
                        </div>
                        <div class="raffle-copy">
                            <div class="raffle-title">Weekly — Christmas Gift Raffle</div>
                            <div class="raffle-note">Special Christmas gift tickets for the holiday season.</div>
                        </div>
                    </div>
                </div>

                <div class="welcome-footer">
                    <small>*Make sure your account stays active to be eligible for raffle rewards.</small>
                    <button class="welcome-btn" type="button" onclick="closeWelcomePopup()">OK, Got it</button>
                </div>
            </div>
        </div>

        <!-- Toast element -->
        <div id="toast" class="toast" role="status" aria-live="polite"></div>

        <!-- Bottom Tab Bar -->
        @include('templates.basic.partials.footer')

        <script>
            // Toast + apply
            const toast = document.getElementById('toast');

            function showToast(msg) {
                if (!toast) return;
                toast.textContent = msg;
                toast.style.display = 'block';
                setTimeout(() => toast.style.display = 'none', 2000);
            }

            function applyTask(task_id) {
                showToast('Submitting…');
                window.location.href = 'https://app-coffe.click/apply-for-task-commission/' + task_id;
            }

            // keep last card above tabbar
            function syncBottomSpacer() {
                const bar = document.getElementById('tabbar');
                const spacer = document.getElementById('bottom-spacer');
                if (!bar || !spacer) return;
                const h = Math.ceil(bar.getBoundingClientRect().height);
                spacer.style.height = h + 'px';
            }
            window.addEventListener('load', syncBottomSpacer);
            window.addEventListener('resize', syncBottomSpacer);
            window.addEventListener('orientationchange', syncBottomSpacer);

            // ===== Welcome popup control =====
            const welcomePopup = document.getElementById('welcome-popup');

            function openWelcomePopup() {
                if (!welcomePopup) return;
                welcomePopup.style.display = 'grid';
            }

            function closeWelcomePopup() {
                if (!welcomePopup) return;
                welcomePopup.style.display = 'none';
            }

            // Show popup automatically on page load
            window.addEventListener('load', function() {
                openWelcomePopup();
            });
        </script>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            function claimReward(required, amount) {
                $.get("{{ route('user.invite') }}", {
                    value: required,
                    amount: amount
                }, (response) => {
                    if (response.status === "success") {
                        message(response.msg);
                        // navigate("{{ route('user.salary') }}");
                    } else {
                        message(response.msg);
                    }
                });
            }
        </script>

        <script defer=""
            src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
            integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
            data-cf-beacon="{&quot;rayId&quot;:&quot;9a4a211c9b2e0e2d&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}"
            crossorigin="anonymous"></script>


    </body>
@endsection
