<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>User Agreement - Xsus</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 0;
        }
        
        
        .page-header {
    display: flex;
    align-items: center;
    background-color: #ffffff;
    padding: 16px 32px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    position: sticky;
    top: 0;
    z-index: 1000;
}

.back-button {
    background-color: #e0e0e0;
    border: none;
    padding: 8px 14px;
    border-radius: 4px;
    font-size: 1rem;
    cursor: pointer;
    margin-right: 20px;
    transition: background-color 0.2s;
}

.back-button:hover {
    background-color: #d0d0d0;
}

.header-title {
    font-size: 1.5rem;
    margin: 0;
    color: #222;
}

        
        

        .container {
            max-width: 800px;
            margin: 40px auto;
            background: #fff;
            padding: 40px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 8px;
        }

        h1,
        h2 {
            color: #222;
        }

        h1 {
            font-size: 2rem;
            margin-bottom: 0.5em;
        }

        h2 {
            margin-top: 2em;
            font-size: 1.3rem;
            border-bottom: 1px solid #ccc;
            padding-bottom: 0.4em;
        }

        hr.separator {
            border: none;
            border-top: 1px solid #ddd;
            margin: 30px 0;
        }

        ul {
            padding-left: 20px;
        }

        ul li {
            margin-bottom: 8px;
        }

        .contact-info {
            margin-top: 1em;
        }

        .contact-info p {
            margin: 5px 0;
        }
    </style>
</head>

<body>

	<header class="page-header">
        <button onclick="history.back()" class="back-button">← Back</button>
        <h1 class="header-title">User Agreement</h1>
    </header>

    <div class="container">
        <h1>User Agreement</h1>
        <p><strong>Effective Date:</strong> June 5, 2025</p>
        <p>Welcome to Xsus (“we”, “our”, “us”). This User Agreement (“Agreement”) governs your access to and use of our
            website, mobile application, and services (collectively, the “Platform”).</p>
        <p>By registering, accessing, or using the Platform, you agree to be bound by this Agreement, our Privacy
            Policy, and any other terms referenced herein. If you do not agree, please do not use our services.</p>

        <hr class="separator" />

        <h2>1. Eligibility</h2>
        <p>You must be at least 18 years old or the age of majority in your jurisdiction to use our services. By using
            the Platform, you represent and warrant that you meet this requirement.</p>

        <hr class="separator" />

        <h2>2. Account Registration</h2>
        <p>You may need to create an account to access certain features. You agree to:</p>
        <ul>
            <li>Provide accurate and complete information during registration.</li>
            <li>Keep your account credentials confidential.</li>
            <li>Be responsible for all activities that occur under your account.</li>
        </ul>

        <hr class="separator" />

        <h2>3. Use of the Platform</h2>
        <p>You agree not to:</p>
        <ul>
            <li>Violate any applicable laws or regulations.</li>
            <li>Use the Platform for any fraudulent or unlawful purposes.</li>
            <li>Interfere with or disrupt the security or performance of the Platform.</li>
            <li>Copy, distribute, or resell any part of the Platform without permission.</li>
        </ul>

        <hr class="separator" />

        <h2>4. Intellectual Property</h2>
        <p>All content, trademarks, and intellectual property on the Platform belong to Xsus or its licensors. You are
            granted a limited, non-exclusive, and non-transferable license to use the Platform in accordance with this
            Agreement.</p>

        <hr class="separator" />

        <h2>5. Termination</h2>
        <p>We reserve the right to suspend or terminate your account at our sole discretion, without notice, if you
            violate this Agreement or misuse our services.</p>

        <hr class="separator" />

        <h2>6. Limitation of Liability</h2>
        <p>To the maximum extent permitted by law, we are not liable for any indirect, incidental, special, or
            consequential damages arising from your use of the Platform.</p>

        <hr class="separator" />

        <h2>7. Changes to the Agreement</h2>
        <p>We may update this Agreement at any time. Continued use of the Platform after changes take effect constitutes
            your acceptance of the new terms.</p>

        <hr class="separator" />

        <h2>8. Contact Us</h2>
        <div class="contact-info">
            <p>📧 Email: <a href="mailto:support@xsus.com">support@xsus.com</a></p>
            <p>📞 Phone: +27 63 236 2051</p>
        </div>
    </div>
</body>

</html>
