@extends('layouts.auth')


@push('page_title')
    Login
@endpush
@section('content')



  <style>
    :root{
      /* Coffeehouse palette inspired by the reference */
      --ink:#3b2613;           /* primary text on light */
      --muted:#7a6a58;         /* secondary text */
      --page:#f7f2e9;          /* paper */
      --panel:#fffaf2;         /* card */
      --panel-2:#f3e7d8;       /* soft tint */
      --line:rgba(0,0,0,.08);  /* hairline */
      --ring:#e9dcc7;          /* badge ring */
      --accent:#b87333;        /* caramel */
      --accent-2:#d6a25e;      /* latte */
      --shadow:0 30px 80px rgba(59,38,19,.20);
    }

    *{box-sizing:border-box;margin:0;padding:0}
    html,body{height:100%}

    /* Textured paper background with your image */
    body{
      font-family: "Segoe UI", system-ui, -apple-system, Roboto, Arial, sans-serif;
      color:var(--ink);
      background:
        radial-gradient(800px 500px at 50% 10%, rgba(255,255,255,.75), rgba(255,255,255,.25) 60%, transparent 70%),
        url('') center/cover no-repeat,
        var(--page);
      min-height:100%;
      display:grid; place-items:center;
      padding:28px 18px;
    }

    /* Card */
    .login-wrap{
      width:min(440px, 100%);
      background:linear-gradient(180deg, var(--panel) 0%, var(--panel-2) 100%);
      border-radius:26px;
      box-shadow:var(--shadow), 0 0 0 1px rgba(0,0,0,.03) inset;
      overflow:hidden;
      position:relative;
      border:1px solid rgba(0,0,0,.05);
    }

    /* Badge header with coffee cup emblem */
    .badge-head{
      position:relative;
      height:180px;
      display:grid;
      place-items:center;
      background:
        radial-gradient(300px 120px at 50% 30%, rgba(214,162,94,.25), transparent 70%),
        linear-gradient(180deg, rgba(0,0,0,.03), rgba(0,0,0,.06));
    }

    .badge{
      width:170px; height:170px; border-radius:50%;
      background:
        radial-gradient(circle at 50% 50%, #f6efe3 0 35%, transparent 36%),
        radial-gradient(circle at 50% 50%, #f0e4d1 0 58%, transparent 59%),
        radial-gradient(circle at 50% 50%, #ead8bf 0 74%, transparent 75%);
      box-shadow:
        0 0 0 6px var(--ring),
        0 0 0 12px #e3d3b7,
        inset 0 0 0 2px rgba(255,255,255,.65),
        0 12px 28px rgba(0,0,0,.10);
      position:relative;
    }

    /* “Since 1972” plate */
    .plate{
      position:absolute; bottom:-12px; left:50%; transform:translateX(-50%);
      background:#fff4e2; border-radius:12px;
      padding:8px 16px;
      box-shadow:0 6px 16px rgba(0,0,0,.12), inset 0 0 0 1px rgba(0,0,0,.06);
      font-weight:900; letter-spacing:.6px; font-size:14px;
      color:var(--ink);
      border:1px solid rgba(0,0,0,.06);
    }

    /* Cup + steam emblem (inline SVG) */
    .emblem{ position:absolute; inset:0; display:grid; place-items:center; pointer-events:none; }
    .brand{
      position:absolute; top:18px; width:100%;
      display:flex; justify-content:center;
      font-weight:900; letter-spacing:1px;
      font-size:18px; color:#5a3a1d; text-shadow:0 1px 0 rgba(255,255,255,.65);
    }

    .content{ padding:22px 18px 24px }

    .legend{
      font-size:13px; color:var(--muted); margin:6px 2px 8px;
      letter-spacing:.25px;
    }

    /* Fields */
    .field{
      display:flex; align-items:center; gap:10px;
      background:#ffffff;
      border:1px solid var(--line);
      border-radius:14px;
      padding:12px 14px;
      box-shadow: inset 0 -2px 0 rgba(0,0,0,.02);
    }
    .field + .legend{ margin-top:14px }

    .field:focus-within{
      border-color:rgba(214,162,94,.7);
      box-shadow:0 0 0 3px rgba(214,162,94,.22), inset 0 -2px 0 rgba(0,0,0,.03);
    }

    .prefix{
      color:#6f4a2a; opacity:.95; font-weight:700; font-variant-numeric:tabular-nums;
    }
    .input{
      flex:1; background:transparent; border:0; color:var(--ink);
      font-size:15px; line-height:22px; outline:none;
    }
    .input::placeholder{ color:#8a7964; opacity:.6 }

    .icon{
      width:18px; height:18px; color:#6f4a2a; opacity:.9; flex:0 0 18px;
    }
    .eye{ cursor:pointer; opacity:.8; transition:opacity .2s ease }
    .eye:hover{ opacity:1 }

    /* CTA */
    .actions{ margin-top:16px }
    .btn{
      width:100%;
      border:0; cursor:pointer;
      border-radius:16px;
      padding:14px 16px;
      color:#3b2613; font-weight:900; font-size:16px; letter-spacing:.2px;
      background:linear-gradient(90deg, var(--accent), var(--accent-2));
      box-shadow:0 12px 28px rgba(214,162,94,.35);
      transition:transform .04s ease, filter .2s ease;
    }
    .btn:active{ transform:translateY(1px) scale(.997) }
    .btn:hover{ filter:brightness(1.03) }

    .register{ margin:12px 2px 0; text-align:center; }
    .register a{
      color:#8a5a2f; text-decoration:none; font-weight:700; font-size:14px
    }
    .register a:hover{ text-decoration:underline }

    /* validation + loading */
    .error-message{ display:none; color:#b24141; font-size:14px; margin:10px 2px 0 }
    .uni-mask{ display:none; position:fixed; inset:0; background:rgba(0,0,0,.15); z-index:9998 }
    .lgi{ display:none; position:fixed; z-index:9999; top:50%; left:50%; transform:translate(-50%,-50%); width:117px; border-radius:12px }

    /* tiny screens */
    @media (max-width:360px){
      .brand{ font-size:16px; letter-spacing:.5px }
      .badge{ width:150px; height:150px }
    }
  </style>

<body>
      <div id="error-message" class="error-message">Invalid input. Please try again.</div>
  
  <div class="login-wrap">
    <!-- Circular badge header -->
    <div class="badge-head">
      <div class="brand">Coffee Blend</div>
      <div class="badge" aria-hidden="true"></div>

      <!-- Coffee cup + steam emblem -->
      <div class="emblem" aria-hidden="true">
        <svg width="200" height="200" viewBox="0 0 200 200" fill="none" aria-hidden="true">
          <!-- steam -->
          <path d="M112 52c14 10 8 22-2 27m-14-9c11 6 6 15-1 19" stroke="#b87333" stroke-width="6" stroke-linecap="round"></path>
          <!-- cup -->
          <path d="M70 86h64c2 26-16 46-46 46s-32-20-30-46z" fill="#fff"></path>
          <path d="M70 86h64c2 26-16 46-46 46s-32-20-30-46z" stroke="#7a4a24" stroke-width="4"></path>
          <!-- handle -->
          <path d="M144 99c14-2 20 6 18 14-2 10-12 14-22 10" stroke="#7a4a24" stroke-width="4" fill="none"></path>
          <!-- bean -->
          <ellipse cx="94" cy="96" rx="12" ry="9" fill="#5a361f"></ellipse>
          <path d="M88 93c4 3 10 3 12 8" stroke="#d6a25e" stroke-width="2" stroke-linecap="round"></path>
        </svg>
      </div>

      <div class="plate">Since 1972</div>
    </div>

    <div class="content">
      <form method="post" action="">
        @csrf
        <div class="legend">Mobile</div>
        <div class="field">
          <span class="prefix">{{ $general->country_code }}</span>
          <input class="input" type="text" name="mobile" inputmode="numeric" autocomplete="tel" placeholder="Mobile" required="">
        </div>

        <div class="legend">Password</div>
        <div class="field">
          <!-- lock icon -->
          <svg class="icon" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
            <path d="M12 1a5 5 0 00-5 5v3H6a2 2 0 00-2 2v7a2 2 0 002 2h12a2 2 0 002-2v-7a2 2 0 00-2-2h-1V6a5 5 0 00-5-5zm-3 8V6a3 3 0 116 0v3H9z"></path>
          </svg>
          <input id="pwd" class="input" type="password" name="password" autocomplete="current-password" placeholder="Password" required="">
          <!-- show/hide -->
          <svg class="icon eye" id="toggleEye" viewBox="0 0 24 24" fill="currentColor" aria-label="Toggle password">
            <path d="M12 5c-5 0-9 4.5-10 7 1 2.5 5 7 10 7s9-4.5 10-7c-1-2.5-5-7-10-7zm0 12a5 5 0 110-10 5 5 0 010 10z"></path>
          </svg>
        </div>

        <div class="actions">
          <button type="button" class="btn" onclick="loginAuth()">Login</button>
        </div>

        <div class="register">
          <a href="#" onclick="window.location.href='{{ route('user.register') }}'">Register Now</a>
        </div>
      </form>
    </div>
  </div>

  <div class="uni-mask"></div>
  <img src="https://i.pinimg.com/originals/34/12/0d/34120d6eac6ceb48cabf121f84a9e3e1.gif" class="lgi" alt="Loading…">

  <script>
    function loginAuth(){
      document.querySelector('.uni-mask').style.display='block';
      document.querySelector('.lgi').style.display='block';
      document.querySelector('form').submit();
    }
    (function(){
      const pwd = document.getElementById('pwd');
      const eye = document.getElementById('toggleEye');
      eye.addEventListener('click', function(){
        pwd.type = pwd.type === 'password' ? 'text' : 'password';
      });
    })();
  </script>
<script defer="" src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon="{&quot;rayId&quot;:&quot;9a497b9c48baef1f&quot;,&quot;version&quot;:&quot;2025.9.1&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;4ab13e381f7c42dfab5a793122eabacc&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfEdge&quot;:true,&quot;cfOrigin&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}" crossorigin="anonymous"></script>


</body></html>
@endsection
