@extends('admin.layouts.app')

@section('panel')
<div class="row justify-content-center">
    <div class="col-xl-4 col-sm-6 mb-30">
        <div class="widget-two box--shadow2 b-radius--5 bg--6">
            <div class="widget-two__content">
                <h2 class="text-white">{{ __($general->cur_sym) }}{{ $total_pending }}</h2>
                <p class="text-white">@lang('Pending Withdrawals')</p>
            </div>
        </div><!-- widget-two end -->
    </div>


    <div class="col-xl-4 col-sm-6 mb-30">
        <div class="widget-two box--shadow2 b-radius--5 bg--6">
            <div class="widget-two__content">
                <h2 class="text-white">{{ __($general->cur_sym) }}{{ $balance_amount}}</h2>
                <p class="text-white">@lang('Flutterwave Balance')</p>
            </div>
        </div><!-- widget-two end -->
    </div>
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">

                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Gateway | Trx')</th>
                                <th>@lang('Initiated')</th>
                                <th>@lang('User')</th>
                                <th>@lang('Amount')</th>
                                <th>Details</th>
                                {{--<th>@lang('Conversion')</th>--}}
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>

                            </tr>
                        </thead>
                        <tbody>
                            @forelse($withdrawals as $withdraw)
                            @php
                            $details = ($withdraw->withdraw_information != null) ? json_encode($withdraw->withdraw_information) : null;
                            @endphp
                            <tr>
                                <td data-label="@lang('Gateway | Trx')">
                                    <span class="font-weight-bold"><a href="{{ route('admin.withdraw.method',[$withdraw->method->id,'all']) }}"> {{ __(@$withdraw->method->name) }}</a></span>
                                    <br>
                                    <small>{{ $withdraw->trx }}</small>
                                </td>
                                <td data-label="@lang('Initiated')">
                                    {{ showDateTime($withdraw->created_at) }} <br>  {{ diffForHumans($withdraw->created_at) }}
                                </td>

                                <td data-label="@lang('User')">
                                    <span class="font-weight-bold">{{ $withdraw->user->fullname }}</span>
                                    <br>
                                    <span class="small"> <a href="{{ route('admin.users.detail', $withdraw->user_id) }}"><span>@</span>{{ $withdraw->user->username }}</a> </span>
                                </td>


                                <td data-label="@lang('Amount')">
                                   {{ __($general->cur_sym) }}{{ showAmount($withdraw->amount ) }} - <span class="text-danger" data-toggle="tooltip" data-original-title="@lang('charge')">{{ showAmount($withdraw->charge)}} </span>
                                    <br>
                                    <strong data-toggle="tooltip" data-original-title="@lang('Amount after charge')">
                                    {{ showAmount($withdraw->amount-$withdraw->charge) }} {{ __($general->cur_text) }}
                                    </strong>

                                </td>

                                <td data-label="Details">
                                    @php
                                        $details = ($withdraw->withdraw_information != null) ? json_encode($withdraw->withdraw_information) : null;
                                    @endphp

                                    @if($details != null)
                                        @foreach(json_decode($details) as $k => $val)

                                            <div>

                                                <span>{{inputTitle($k)}}</span>=><span>{{$val->field_name}}</span>

                                                @if($k == "bank_name")
                                                    ({{ get_bank_name($val->field_name) }})
                                                @endif
                                            </div>

                                        @endforeach
                                    @endif

                                    @if($withdraw->method->is_bank && $withdraw->user->bankAccount)
                                        Account Name - {{ $withdraw->user->bankAccount->account_name }} <br> Account Number - {{ $withdraw->user->bankAccount->account_number }}
                                        <br> Bank Name - {{ $withdraw->user->bankAccount->bank_name }}
                                    @endif

                                    @if(!$withdraw->method->is_bank && $withdraw->user->wallet_address != "")
                                        <hr>
                                        <span>{{ $withdraw->user->wallet_address }}</span>
                                    @endif
                                </td>

                                <td data-label="@lang('Action')">

                                    @if($withdraw->status == 2)

                                        <form action="{{ route('admin.withdraw.approve') }}" method="POST"  style="display: inline-block">
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $withdraw->id }}">
                                            <input type="hidden" name="details" value="Paid" />
                                            <button type="submit" class="btn btn--success btn-sm">@lang('Pay Auto')</button>
                                        </form>


                                        <form action="{{ route('admin.withdraw.approve') }}" method="POST"  style="display: inline-block">
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $withdraw->id }}">
                                            <input type="hidden" name="details" value="Paid" />
                                            <input type="hidden" name="is_manual" value="1">
                                            <button type="submit" class="btn btn--success btn-sm">@lang('Approve Manually')</button>
                                        </form>

                                    @endif

                                    <a href="{{ route('admin.withdraw.details', $withdraw->id) }}" class="icon-btn ml-1 " data-toggle="tooltip" data-original-title="@lang('Detail')">
                                        <i class="la la-desktop"></i>
                                    </a>
                                </td>

                                {{--<td data-label="@lang('Conversion')">
                                   1 {{ __($general->cur_text) }} =  {{ getAmount($withdraw->rate) }} {{ __($withdraw->currency) }}
                                    <br>
                                    <strong>{{ getAmount($withdraw->final_amount) }} {{ __($withdraw->currency) }}</strong>
                                </td>--}}



                                <td data-label="@lang('Status')">
                                    @if($withdraw->status == 2)
                                        <span class="text--small badge font-weight-normal badge--warning">@lang('Pending')</span>
                                    @elseif($withdraw->status == 1)
                                        <span class="text--small badge font-weight-normal badge--success">@lang('Approved')</span>
                                        <br>{{ diffForHumans($withdraw->updated_at) }}
                                    @elseif($withdraw->status == 3)
                                        <span class="text--small badge font-weight-normal badge--danger">@lang('Rejected')</span>
                                        <br>{{ diffForHumans($withdraw->updated_at) }}
                                    @endif
                                </td>


                            </tr>
                        @empty
                        <tr>
                            <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                        </tr>
                        @endforelse

                    </tbody>
                </table><!-- table end -->
            </div>
        </div>

        <div class="card-footer py-4">
            {{ paginateLinks($withdrawals) }}
        </div>
    </div><!-- card end -->
</div>
</div>

@endsection




@push('breadcrumb-plugins')

    @if(!request()->routeIs('admin.users.withdrawals') && !request()->routeIs('admin.users.withdrawals.method'))

    <form action="{{ route('admin.withdraw.search', $scope ?? str_replace('admin.withdraw.', '', request()->route()->getName())) }}" method="GET" class="form-inline float-sm-right bg--white mb-2 ml-0 ml-xl-2 ml-lg-0">
        <div class="input-group has_append">
            <input type="text" name="search" class="form-control" placeholder="@lang('Trx number/Username')" value="{{ $search ?? '' }}">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>
    <form action="{{route('admin.withdraw.dateSearch',$scope ?? str_replace('admin.withdraw.', '', request()->route()->getName()))}}" method="GET" class="form-inline float-sm-right bg--white">
        <div class="input-group has_append">
            <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en" class="datepicker-here form-control" data-position='bottom right' placeholder="@lang('Min Date - Max date')" autocomplete="off" value="{{ @$dateSearch }}">
            <input type="hidden" name="method" value="{{ @$method->id }}">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>
    @endif
@endpush
@push('script-lib')
<script src="{{ asset('assets/admin/js/vendor/datepicker.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/vendor/datepicker.en.js') }}"></script>
@endpush
@push('script')
<script>
    (function($){
        'use strict';
        if(!$('.datepicker-here').val()){
            $('.datepicker-here').datepicker();
        }
    })(jQuery)
</script>
@endpush
